/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper;

import com.excentis.products.byteblower.report.data.entities.core.ReportOutputFormat;
import com.excentis.products.byteblower.report.data.entities.templates.ReportTemplateEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.AbstractAction;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.report.generator.core.parameters.ReportParameter;
import com.excentis.products.byteblower.report.generator.jasper.GenerateReport;
import com.excentis.products.byteblower.report.generator.jasper.MasterBean;
import com.excentis.products.byteblower.report.generator.jasper.datasource.SnapshotCounter;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.utils.Utils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.fill.JRGzipVirtualizer;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class GenerateMasterReport
extends GenerateReport<GenerateReportListener> {
    private static final Logger LOGGER = Logger.getGlobal();
    private static final int PAGE_WIDTH_A4 = 1020;
    private static final int MASTER_WIDTH = 1020;
    private static final String DESIGN_FILENAME = "master_report";
    private ReportTemplateEntity reportTemplate;
    private ReportPreferencesInterface reportPreferences;

    public static AbstractAction create(ReportGeneration reportGeneration, ReportPreferencesInterface reportPreference, ReportTemplateEntity reportTemplate, GenerateReportListener listener, IProgressMonitor monitor) {
        return new GenerateMasterReport(reportGeneration, reportPreference, reportTemplate, listener, monitor);
    }

    private GenerateMasterReport(ReportGeneration reportGeneration, ReportPreferencesInterface reportPreference, ReportTemplateEntity reportTemplate, GenerateReportListener listener, IProgressMonitor progressMonitor) {
        super(listener, progressMonitor);
        this.setReportGeneration(reportGeneration);
        this.reportPreferences = reportPreference;
        this.reportTemplate = reportTemplate;
    }

    private void compileToFormat(ReportOutputFormat format) {
        this.initializeLog4J();
        this.loadJasperDesign();
        this.generateSubReports();
        this.dynamicLayout();
        JasperReport jasperReport = this.compileReport(GenerateMasterReport.isGeneratingPages());
        this.addGeneralParameters();
        if (this.needToExport()) {
            AbstractAction g = this.exportReport(this.fillReport(jasperReport), format);
            g.invoke();
        }
        this.writeDebugInfo("MASTER");
    }

    private void compileToFormats(Collection<ReportOutputFormat> outFormats) {
        for (ReportOutputFormat format : outFormats) {
            SnapshotCounter.reset();
            this.reset();
            GenerateMasterReport.setCurrentFormat(format);
            this.compileToFormat(format);
        }
    }

    public void invokeImpl() {
        ArrayList<ReportOutputFormat> formats = new ArrayList<ReportOutputFormat>(this.getOutputFormats());
        if (formats.contains(ReportOutputFormat.deprecatedjasperhtml)) {
            formats.remove(ReportOutputFormat.deprecatedjasperhtml);
            formats.add(0, ReportOutputFormat.deprecatedjasperhtml);
        }
        this.compileToFormats(formats);
    }

    private void dynamicLayout() {
        this.setMasterPageSizeA4();
        this.stretchTitleBox();
        this.putProductByExcentisRight();
    }

    private void setMasterPageSizeA4() {
        this.jasperDesign.setPageWidth(1020);
        this.setPageHeight();
    }

    private void stretchTitleBox() {
        JRBand band = this.jasperDesign.getTitle();
        JRElement[] elements = band.getElements();
        JRElement orangeTitleBox = elements[0];
        int width = 1020 - this.jasperDesign.getLeftMargin() - this.jasperDesign.getRightMargin();
        orangeTitleBox.setWidth(width);
    }

    private void putProductByExcentisRight() {
        JRBand band = this.jasperDesign.getTitle();
        JRElement[] elements = band.getElements();
        JRElement productByExcentis = elements[1];
        int width = productByExcentis.getWidth();
        int x = 1020 - this.jasperDesign.getLeftMargin() - this.jasperDesign.getRightMargin() - width;
        productByExcentis.setX(x);
    }

    private JasperPrint fillReport(JasperReport jasperReport) {
        Map<String, Object> parameters = this.getParameters();
        JasperFillManager fillManager = this.getFillManager();
        JasperPrint jasperPrint = null;
        JRGzipVirtualizer virtualizer = new JRGzipVirtualizer(10);
        parameters.put("REPORT_VIRTUALIZER", virtualizer);
        Collection<MasterBean> masterDummyData = this.getMasterDummyData();
        JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(masterDummyData);
        try {
            jasperPrint = fillManager.fill(jasperReport, parameters, (JRDataSource)dataSource);
        }
        catch (JRException e) {
            throw new RuntimeException(e);
        }
        ((GenerateReportListener)this.getListener()).onReportFilled();
        return jasperPrint;
    }

    private void addGeneralParameters() {
        this.addCascadeParameter((ReportParameter)this.reportPreferences.getThroughputType());
        this.addCascadeParameter((ReportParameter)this.reportPreferences.getDataRateUnit());
        this.addCascadeParameter((ReportParameter)this.reportPreferences.getWarningLossLevel());
        this.addCascadeParameter((ReportParameter)this.reportPreferences.getErrorLossLevel());
        this.addCascadeParameter((ReportParameter)this.reportPreferences.getLatencyUnit());
        this.addCascadeParameter((ReportParameter)this.reportPreferences.getThroughputPattern());
        this.addCascadeParameter((ReportParameter)this.reportPreferences.getLatencyPattern());
    }

    private Collection<MasterBean> getMasterDummyData() {
        MasterBean dummyBean = new MasterBean();
        ArrayList<MasterBean> data = new ArrayList<MasterBean>();
        data.add(dummyBean);
        return data;
    }

    public String getDescription() {
        return "Generate Report with Template " + this.reportTemplate.getName();
    }

    private void initializeLog4J() {
        Bundle bundle = Platform.getBundle((String)"com.excentis.products.byteblower.report.generator.jasper");
        URL bundleEntryUrl = bundle.getEntry("log4j.properties");
        try {
            PropertyConfigurator.configure((URL)FileLocator.toFileURL((URL)bundleEntryUrl));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Set<ReportOutputFormat> getOutputFormats() {
        return this.reportPreferences.getOutputFormats();
    }

    @Override
    protected ReportPreferencesInterface getReportPreferences() {
        return this.reportPreferences;
    }

    private void generateSubReports() {
        Map<Integer, Object> rowMap;
        HashMap gridMap = new HashMap();
        for (ReportItemWidgetEntity widget : this.reportTemplate.getReportItemWidgets()) {
            Integer row = widget.getRowPosition();
            Integer column = widget.getColumnPosition();
            rowMap = (Map)gridMap.get(row);
            if (rowMap == null) {
                rowMap = new HashMap<Integer, ReportItemWidgetEntity>();
                gridMap.put(row, rowMap);
            } else if (rowMap.containsKey(column)) {
                LOGGER.warning("GenerateMasterReport::generateSubReports : Warning : there already is an item on this grid position !");
            }
            rowMap.put(column, widget);
        }
        boolean checkRow = true;
        Integer row = 0;
        while (checkRow) {
            rowMap = (HashMap<Integer, ReportItemWidgetEntity>)gridMap.get(row);
            if (rowMap == null) {
                checkRow = false;
                continue;
            }
            this.insertRow((Map<Integer, ReportItemWidgetEntity>)rowMap, 1020);
            row = row + 1;
        }
    }

    @Override
    protected String getDesignFileName() {
        return DESIGN_FILENAME;
    }

    @Override
    protected String getOutputPath() {
        TestDataReference ref = this.getTestDataReference();
        Path path = new Path(this.reportPreferences.getOutputLocation());
        String runTitle = ref.getTestRunTitle();
        if (runTitle != null && !runTitle.isEmpty()) {
            path = path.append(runTitle);
        }
        return path.toOSString();
    }

    @Override
    protected String getOutputFile() {
        TestDataReference ref = this.getTestDataReference();
        Path path = new Path(this.getOutputPath());
        return Utils.createReportFileNameBase((IPath)path, (String)ref.getTestRunTitle(), (String)ref.getTestName(), (Date)ref.getStartTime(), (String)"R1");
    }

    @Override
    protected boolean isSubReport() {
        return false;
    }

    @Override
    protected boolean needToExport() {
        return true;
    }

    @Override
    protected boolean hasSubReports() {
        return true;
    }

    @Override
    public void onReportExported(String outputFile, ReportOutputFormat outputFormat) {
        ReportGeneration reportGeneration = this.getReportGeneration();
        ((GenerateReportListener)this.getListener()).onReportExported(reportGeneration, outputFile, outputFormat);
    }
}

