/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper;

import com.excentis.products.byteblower.report.data.entities.core.ReportOutputFormat;
import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.AbstractAction;
import com.excentis.products.byteblower.report.generator.core.ConcreteAction;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.report.generator.core.parameters.DataRateUnitParameter;
import com.excentis.products.byteblower.report.generator.core.parameters.LatencyUnitParameter;
import com.excentis.products.byteblower.report.generator.core.parameters.ParameterConvertor;
import com.excentis.products.byteblower.report.generator.core.parameters.ReportParameter;
import com.excentis.products.byteblower.report.generator.core.parameters.ThroughputTypeParameter;
import com.excentis.products.byteblower.report.generator.jasper.ExportReport;
import com.excentis.products.byteblower.report.generator.jasper.GenerateSubReport;
import com.excentis.products.byteblower.report.generator.jasper.SubReportGeneratorFactory;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.testdata.data.ScenarioManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import com.excentis.products.byteblower.results.testdata.data.utils.EthernetThroughputType;
import com.excentis.products.byteblower.results.testdata.data.utils.LatencyUnit;
import jakarta.persistence.EntityManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import net.sf.jasperreports.engine.type.SplitTypeEnum;
import net.sf.jasperreports.engine.type.WhenNoDataTypeEnum;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.LocalJasperReportsContext;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.osgi.framework.Bundle;

public abstract class GenerateReport<Listener extends GenerateReportListener>
extends ConcreteAction<Listener>
implements ExportReport.Listener {
    static final int space_between_subreports = 10;
    private static ReportOutputFormat currentFormat;
    private static final Logger LOGGER;
    protected JasperDesign jasperDesign = null;
    private LocalJasperReportsContext context = null;
    private JasperFillManager fillManager = null;
    private JasperExportManager exportManager = null;
    private Map<String, Object> parameters = null;
    protected JasperReport compiledJasperReport = null;
    private GenerateReport<Listener> parentReport = null;
    private ReportGeneration reportGeneration;
    private IProgressMonitor progressMonitor;
    private final String jasperi18nbundle = "designs/i18n/i18nResource";

    static {
        LOGGER = Logger.getGlobal();
    }

    static boolean isGeneratingPages() {
        return currentFormat.isPaginated();
    }

    static void setCurrentFormat(ReportOutputFormat format) {
        currentFormat = format;
    }

    private static ReportOutputFormat getCurrentFormat() {
        return currentFormat;
    }

    public GenerateReport<Listener> getParentReport() {
        return this.parentReport;
    }

    GenerateReport(GenerateReport<Listener> parentReport, Listener listener, IProgressMonitor progressMonitor) {
        this(listener, progressMonitor);
        this.parentReport = parentReport;
    }

    GenerateReport(Listener listener, IProgressMonitor progressMonitor) {
        super(listener);
        this.progressMonitor = progressMonitor;
        this.reset();
    }

    void reset() {
        this.jasperDesign = null;
        this.context = null;
        this.fillManager = null;
        this.exportManager = null;
        this.parameters = null;
        this.compiledJasperReport = null;
        this.initParameters();
    }

    private void initParameters() {
        this.addParameter("REPORT_LOCALE", Locale.getDefault(Locale.Category.FORMAT));
        this.addParameter("REPORT_RESOURCE_BUNDLE", ResourceBundle.getBundle("designs/i18n/i18nResource", Locale.ENGLISH, this.getClass().getClassLoader()));
        this.addParameter("REPORT_TIME_ZONE", TimeZone.getDefault());
    }

    private LocalJasperReportsContext getContext() {
        if (this.context == null) {
            FileResolver resolver = new FileResolver(){

                public File resolveFile(String filename) {
                    Bundle bundle = Platform.getBundle((String)"com.excentis.products.byteblower.report.generator.jasper");
                    URL fileURL = bundle.getEntry("/designs/" + filename);
                    try {
                        URL url = FileLocator.toFileURL((URL)fileURL);
                        URI uri = URIUtil.toURI((URL)url);
                        return new File(uri);
                    }
                    catch (URISyntaxException e1) {
                        throw new RuntimeException(e1);
                    }
                    catch (IOException e1) {
                        throw new RuntimeException(e1);
                    }
                }
            };
            this.context = new LocalJasperReportsContext((JasperReportsContext)DefaultJasperReportsContext.getInstance());
            this.context.setClassLoader(this.getClass().getClassLoader());
            this.context.setFileResolver(resolver);
        }
        return this.context;
    }

    protected JasperFillManager getFillManager() {
        if (this.fillManager == null) {
            LocalJasperReportsContext currentContext = this.getContext();
            this.fillManager = JasperFillManager.getInstance((JasperReportsContext)currentContext);
        }
        return this.fillManager;
    }

    protected JasperExportManager getExportManager() {
        if (this.exportManager == null) {
            LocalJasperReportsContext currentContext = this.getContext();
            this.exportManager = JasperExportManager.getInstance((JasperReportsContext)currentContext);
        }
        return this.exportManager;
    }

    protected AbstractAction exportReport(JasperPrint jasperPrint, ReportOutputFormat format) {
        String reportFile;
        ConcreteAction<ExportReport.Listener> result = new ConcreteAction<ExportReport.Listener>(this.parentReport){

            public String getDescription() {
                return "Empty Action";
            }

            protected void invokeImpl() {
            }
        };
        String reportPath = this.getOutputPath();
        if (reportPath != null) {
            new File(reportPath).mkdirs();
        }
        if ((reportFile = this.getOutputFile()) != null) {
            result = ExportReport.create(this, jasperPrint, reportFile, format, this.progressMonitor);
        }
        return result;
    }

    protected abstract boolean needToExport();

    protected abstract boolean isSubReport();

    protected boolean isMasterReport() {
        return !this.isSubReport();
    }

    @Override
    public void onReportExported(String outputFile, ReportOutputFormat outputFormat) {
    }

    @Override
    public void onReportExportFailed(ReportOutputFormat outputFormat, Exception ex) {
        ((GenerateReportListener)this.getListener()).onReportFailed(outputFormat, new Exception("An error occurred while exporting the report to " + outputFormat, ex));
    }

    protected String getOutputPath() {
        return null;
    }

    protected String getOutputFile() {
        return null;
    }

    protected Set<ReportOutputFormat> getOutputFormats() {
        return Collections.emptySet();
    }

    protected JasperReport compileReport(boolean genPages) {
        try {
            this.jasperDesign.setIgnorePagination(!genPages);
            this.compiledJasperReport = JasperCompileManager.compileReport((JasperDesign)this.jasperDesign);
        }
        catch (JRException e) {
            throw new RuntimeException(e);
        }
        if (this.compiledJasperReport != null) {
            ((GenerateReportListener)this.getListener()).onReportCompiled();
        }
        return this.compiledJasperReport;
    }

    protected abstract boolean hasSubReports();

    protected JasperDesign loadJasperDesign() {
        String designFileName = this.getDesignFileName();
        return this.loadJasperDesign(designFileName);
    }

    private JasperDesign loadJasperDesign(String designFileName) {
        InputStream in = this.getClass().getResourceAsStream("/designs/" + designFileName + ".jrxml");
        try {
            this.jasperDesign = JRXmlLoader.load((InputStream)in);
            this.jasperDesign.setName(designFileName);
            this.jasperDesign.setWhenNoDataType(WhenNoDataTypeEnum.ALL_SECTIONS_NO_DETAIL);
            this.jasperDesign.setIgnorePagination(false);
            ((GenerateReportListener)this.getListener()).onReportFileLoaded();
        }
        catch (JRException e) {
            LOGGER.warning("GenerateReport::loadJasperDesign " + designFileName + " : " + e.getMessage());
            throw new RuntimeException(e);
        }
        return this.jasperDesign;
    }

    protected abstract String getDesignFileName();

    protected ReportPreferencesInterface getReportPreferences() {
        return this.parentReport.getReportPreferences();
    }

    protected Map<String, Object> getParameters() {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>();
        }
        return this.parameters;
    }

    private void addParameter(String key, Object value) {
        this.getParameters().put(key, value);
    }

    protected void addCascadeParameter(ReportParameter reportParameter) {
        this.addCascadeParameter(reportParameter.getKey(), reportParameter.getValue(), reportParameter.getClazz());
    }

    protected void addCascadeParameter(String key, Object value, Class<?> clazz) {
        this.addParameter(key, value, clazz);
        if (this.isSubReport()) {
            this.parentReport.addCascadeParameter(key, value, clazz);
        }
    }

    protected void registerParameter(String key, Class<?> clazz) {
        this.addCascadeParameter(key, null, clazz);
    }

    protected void registerParameter(ReportParameter param) {
        this.registerParameter(param.getKey(), param.getClazz());
    }

    protected void addParameter(String key, Object value, Class<?> clazz) {
        this.addParameter(key, value);
        if (this.jasperDesign.getParametersMap().containsKey(key)) {
            return;
        }
        JRDesignParameter designParameter = new JRDesignParameter();
        designParameter.setName(key);
        designParameter.setValueClass(clazz);
        try {
            this.jasperDesign.addParameter((JRParameter)designParameter);
        }
        catch (JRException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean insertSubReport(JRDesignBand designBand, ReportItemWidgetEntity widget, Integer column, int subReportWidth) {
        return this.insertSubReport(designBand, widget, column, subReportWidth, 0);
    }

    protected boolean insertSubReport(JRDesignBand designBand, ReportItemWidgetEntity widget, Integer column, int subReportWidth, int posY) {
        return this.insertSubReport(designBand, widget, column, subReportWidth, posY, null, true);
    }

    protected boolean insertSubReport(JRDesignBand designBand, ReportItemWidgetEntity widget, Integer column, int subReportWidth, int posY, JRExpression dataSourceExpression, boolean needAdd) {
        SubReportGeneratorFactory subReportFactory = SubReportGeneratorFactory.getInstance(currentFormat);
        GenerateReport parent = this;
        GenerateSubReport action = subReportFactory.create(parent, widget, this.reportGeneration);
        action.invoke();
        if (action.showSubReport()) {
            JRDesignSubreport subReportDesign = dataSourceExpression == null ? action.createSubReportDesign() : action.createSubReportDesign(dataSourceExpression);
            if (needAdd) {
                subReportDesign.setX(subReportWidth * column);
                subReportDesign.setY(posY);
                subReportDesign.setWidth(subReportWidth);
                this.addElementAtBottomOfBand(designBand, widget, (JRDesignElement)subReportDesign);
            }
            return true;
        }
        return false;
    }

    private void addElementAtBottomOfBand(JRDesignBand designBand, ReportItemWidgetEntity widget, JRDesignElement designElement) {
        designBand.addElement(designElement);
        int newBandHeight = designBand.getOrigin() != null && BandTypeEnum.DETAIL == designBand.getOrigin().getBandTypeValue() ? Math.max(designBand.getHeight(), designElement.getY() + designElement.getHeight()) : designBand.getHeight() + designElement.getHeight();
        designBand.setHeight(newBandHeight);
    }

    protected void insertRow(Map<Integer, ReportItemWidgetEntity> rowMap, int parentWidth) {
        JRDesignBand designBand = this.createDesignBand();
        int nofColumns = rowMap.size();
        int subReportWidth = parentWidth / nofColumns;
        boolean checkColumn = true;
        Integer column = new Integer(0);
        while (checkColumn) {
            ReportItemWidgetEntity widget = rowMap.get(column);
            if (widget == null) {
                checkColumn = false;
                continue;
            }
            if (widget.showInOutputFormat(GenerateReport.getCurrentFormat())) {
                this.insertSubReport(designBand, widget, column, subReportWidth);
            }
            column = column + 1;
        }
        int maxHeight = 0;
        JRElement[] jRElementArray = designBand.getElements();
        int n = jRElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRElement element = jRElementArray[n2];
            int elementHeight = element.getY() + element.getHeight();
            if (elementHeight > maxHeight) {
                maxHeight = elementHeight;
            }
            ++n2;
        }
        designBand.setHeight(maxHeight);
        if (designBand.getElements().length > 0) {
            JRDesignSection designSection = (JRDesignSection)this.jasperDesign.getDetailSection();
            designSection.addBand((JRBand)designBand);
        }
    }

    protected JRDesignBand createDesignBand() {
        JRDesignBand designBand = new JRDesignBand();
        designBand.setSplitType(SplitTypeEnum.STRETCH);
        return designBand;
    }

    public ReportGeneration getReportGeneration() {
        return this.reportGeneration;
    }

    public void setReportGeneration(ReportGeneration reportGeneration) {
        this.reportGeneration = reportGeneration;
    }

    public TestDataReference getTestDataReference() {
        return this.reportGeneration.getTestDataReference();
    }

    protected Scenario getScenario() {
        String scenarioName = this.getTestDataReference().getTestName();
        ScenarioManager manager = this.getScenarioManager();
        return manager.find(scenarioName);
    }

    private ScenarioManager getScenarioManager() {
        return new ScenarioManager(this.getPersistenceController());
    }

    protected TestDataPersistenceController getPersistenceController() {
        return TestDataPersistenceController.getInstance((Long)this.getTestDataReference().getId());
    }

    public EntityManager getEntityManager() {
        return this.getPersistenceController().getEntityManager();
    }

    protected void setPageHeight() {
        int totalHeight = 0;
        JRBand[] jRBandArray = this.jasperDesign.getAllBands();
        int n = jRBandArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRBand band = jRBandArray[n2];
            totalHeight += band.getHeight();
            ++n2;
        }
        this.jasperDesign.setPageHeight(totalHeight);
    }

    public DataRateUnit getDataRateUnit() {
        ReportPreferencesInterface preferences = this.getReportPreferences();
        return ParameterConvertor.convertDataRateUnit((DataRateUnitParameter)preferences.getDataRateUnit());
    }

    public LatencyUnit getLatencyUnit() {
        ReportPreferencesInterface preferences = this.getReportPreferences();
        return ParameterConvertor.convertLatencyUnit((LatencyUnitParameter)preferences.getLatencyUnit());
    }

    public EthernetThroughputType getEthernetThroughputType() {
        ReportPreferencesInterface preferences = this.getReportPreferences();
        ThroughputTypeParameter throughputType = preferences.getThroughputType();
        return ParameterConvertor.convertThroughputType((ThroughputTypeParameter)throughputType);
    }

    protected void writeDebugInfo(String identifier) {
    }
}

