/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper;

import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.jasper.GenerateReport;
import com.excentis.products.byteblower.report.generator.jasper.SubReportParameter;
import com.excentis.products.byteblower.report.generator.jasper.datasource.ByteBlowerReportDataSource;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.type.PositionTypeEnum;
import net.sf.jasperreports.engine.type.StretchTypeEnum;

public abstract class GenerateSubReport
extends GenerateReport<GenerateReportListener> {
    private static final Logger LOGGER = Logger.getGlobal();
    private static int instanceCounter = 0;
    protected ReportItemWidgetEntity widget;
    private int instanceId;
    private ByteBlowerReportDataSource dataSource = null;

    protected GenerateSubReport(GenerateReport<GenerateReportListener> parentReport, ReportItemWidgetEntity widget, ReportGeneration reportGeneration, GenerateReportListener listener) {
        super(parentReport, listener, null);
        this.widget = widget;
        this.setReportGeneration(reportGeneration);
        this.instanceId = instanceCounter++;
    }

    public String getDescription() {
        return "Generate Subreport for Widget :" + this.widget;
    }

    public void invokeImpl() {
        if (this.showSubReport()) {
            this.loadJasperDesign();
            if (this.hasSubReports()) {
                this.generateSubReports();
            }
            this.dynamicLayout();
            this.compileReport(GenerateSubReport.isGeneratingPages());
            this.addDataSourceParameter();
            this.registerParameters();
            this.addSubReportToParent();
            this.writeDebugInfo(this.getDataSourceParameterName());
        }
    }

    public abstract boolean showSubReport();

    protected abstract ByteBlowerReportDataSource initializeDataSourceAsParameter();

    protected ByteBlowerReportDataSource getDataSourceAsParameter() {
        if (this.dataSource == null) {
            this.dataSource = this.initializeDataSourceAsParameter();
        }
        return this.dataSource;
    }

    private void dynamicLayout() {
        this.setPageHeight();
    }

    protected void registerParameters() {
        this.registerParameter("data_rate_unit", String.class);
        this.registerParameter("time_unit", String.class);
        this.registerParameter("latency_pattern", String.class);
        this.registerParameter("throughput_pattern", String.class);
    }

    protected void generateSubReports() {
    }

    JRDesignSubreport createSubReportDesign() {
        String dataSourceParameterName = this.getDataSourceParameterName();
        JRExpression dataSourceExpression = this.createParameterExpression(dataSourceParameterName);
        return this.createSubReportDesign(dataSourceExpression);
    }

    JRDesignSubreport createSubReportDesign(JRExpression sourceExpression) {
        JRDesignSubreport subReportDesign = new JRDesignSubreport((JRDefaultStyleProvider)this.jasperDesign);
        subReportDesign.setPositionType(PositionTypeEnum.FIX_RELATIVE_TO_TOP);
        subReportDesign.setStretchType(StretchTypeEnum.NO_STRETCH);
        int totalHeight = this.getHeight();
        subReportDesign.setHeight(totalHeight);
        subReportDesign.setDataSourceExpression(sourceExpression);
        String subReportParameterName = this.getSubReportParameterName();
        JRExpression subReportExpression = this.createParameterExpression(subReportParameterName);
        subReportDesign.setExpression(subReportExpression);
        for (String key : this.getParameters().keySet()) {
            this.linkParameter(subReportDesign, key);
        }
        return subReportDesign;
    }

    private void linkParameter(JRDesignSubreport subReportDesign, String key) {
        JRExpression subReportParameterExpression = this.createParameterExpression(key);
        SubReportParameter subReportParameter = new SubReportParameter(key, subReportParameterExpression);
        try {
            subReportDesign.addParameter((JRSubreportParameter)subReportParameter);
        }
        catch (JRException e) {
            throw new RuntimeException(e);
        }
    }

    private String getDataSourceParameterName() {
        return "BYTEBLOWER_SUB_REPORT_DATA_SOURCE_FOR_" + this.getSubReportIdentifier();
    }

    private String getSubReportParameterName() {
        return "BYTEBLOWER_SUB_REPORT_" + this.getSubReportIdentifier();
    }

    private void addSubReportToParent() {
        String subReportParameterName = this.getSubReportParameterName();
        this.addCascadeParameter(subReportParameterName, this.getCompiledJasperReport(), JasperReport.class);
    }

    private JasperReport getCompiledJasperReport() {
        if (this.compiledJasperReport == null) {
            LOGGER.warning("The Jasper Report has not yet been compiled !");
        }
        return this.compiledJasperReport;
    }

    private void addDataSourceParameter() {
        ByteBlowerReportDataSource jrDataSource = this.getDataSourceAsParameter();
        if (jrDataSource != null) {
            Class<?> jrDataClass = jrDataSource.getJRDataSourceClass();
            String dataSourceParameterName = this.getDataSourceParameterName();
            this.addCascadeParameter(dataSourceParameterName, jrDataSource, jrDataClass);
        }
    }

    private JRExpression createParameterExpression(String parameter) {
        return new JRDesignExpression("$P{" + parameter + "}");
    }

    protected String getSubReportIdentifier() {
        return String.valueOf(this.widget.getReportDesignFile()) + "_" + this.instanceId;
    }

    @Override
    protected boolean hasSubReports() {
        return false;
    }

    @Override
    protected String getDesignFileName() {
        return this.widget.getReportDesignFile();
    }

    @Override
    protected String getOutputFile() {
        return "./temp_subreport_" + this.getDesignFileName() + ".html";
    }

    @Override
    protected boolean isSubReport() {
        return true;
    }

    @Override
    protected boolean needToExport() {
        return false;
    }

    public int getHeight() {
        int height = 10;
        JRBand[] jRBandArray = this.compiledJasperReport.getAllBands();
        int n = jRBandArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRBand band = jRBandArray[n2];
            height += band.getHeight();
            ++n2;
        }
        return height;
    }

    protected ReportItemWidgetEntity getWidget() {
        return this.widget;
    }
}

