/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper;

import com.excentis.products.byteblower.report.generator.core.parameters.DataRateUnitParameter;
import com.excentis.products.byteblower.report.generator.core.parameters.LatencyUnitParameter;
import com.excentis.products.byteblower.report.generator.core.parameters.ThroughputType;
import com.excentis.products.byteblower.report.generator.core.parameters.ThroughputTypeParameter;
import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import com.excentis.products.byteblower.results.testdata.data.utils.EthernetThroughputType;
import com.excentis.products.byteblower.results.testdata.data.utils.LatencyUnit;

public class ParameterConvertor {
    public static DataRateUnit ConvertDataRateUnit(DataRateUnitParameter datarate) {
        switch (datarate.rawUnit) {
            case BPS: {
                return DataRateUnit.BIT_PER_SECOND;
            }
            case BYTESPS: {
                return DataRateUnit.BYTE_PER_SECOND;
            }
            case KBPS: {
                return DataRateUnit.KILOBIT_PER_SECOND;
            }
            case KBYTESPS: {
                return DataRateUnit.KILOBYTE_PER_SECOND;
            }
            case MBPS: {
                return DataRateUnit.MEGABIT_PER_SECOND;
            }
            case MBYTESPS: {
                return DataRateUnit.MEGABYTE_PER_SECOND;
            }
            case GBPS: {
                return DataRateUnit.GIGABIT_PER_SECOND;
            }
            case GBYTESPS: {
                return DataRateUnit.GIGABYTE_PER_SECOND;
            }
        }
        return DataRateUnit.BIT_PER_SECOND;
    }

    public static EthernetThroughputType ConvertThroughputType(ThroughputTypeParameter parameter) {
        ThroughputType type = (ThroughputType)parameter.getValue();
        switch (type) {
            case FRAME_ONLY: {
                return EthernetThroughputType.FRAME_ONLY;
            }
            case FRAME_AND_FCS: {
                return EthernetThroughputType.FRAME_WITH_FCS;
            }
            case FRAME_AND_ALL_OTHER_FIELDS: {
                return EthernetThroughputType.FRAME_FULL_LAYER1_INCL_IFG;
            }
        }
        return EthernetThroughputType.FRAME_ONLY;
    }

    public static LatencyUnit ConvertLatencyUnit(LatencyUnitParameter parameter) {
        return parameter.rawUnit;
    }
}

