/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.chartCustomizer;

import com.excentis.products.byteblower.report.generator.jasper.chartCustomizer.ProxyRender;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartCustomizer;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.SeriesRenderingOrder;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;

public class AggregateChart
implements JRChartCustomizer,
Serializable {
    private static final long serialVersionUID = 1L;

    public void customize(JFreeChart chartImage, JRChart chartLocation) {
        ColourSeries colours = new ColourSeries(29866L);
        XYPlot plot = chartImage.getXYPlot();
        AggregateRenderer renderer = new AggregateRenderer(plot, colours);
        Range domainRange = plot.getDomainAxis().getRange();
        double upper = domainRange.getUpperBound() + (domainRange.getUpperBound() - domainRange.getLowerBound()) * 0.11;
        plot.getDomainAxis().setRange(new Range(domainRange.getLowerBound(), upper));
        plot.setSeriesRenderingOrder(SeriesRenderingOrder.FORWARD);
        plot.setRenderer((XYItemRenderer)new ProxyRender((XYItemRenderer)renderer));
    }

    private static class AggregateRenderer
    extends AbstractXYItemRenderer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Measurement[] pastMeasures = new Measurement[0];
        private List<int[]> xCors = new ArrayList<int[]>();
        private List<int[]> yCors = new ArrayList<int[]>();
        private final ArrayList<Color> colours;

        public AggregateRenderer() {
            this.colours = new ArrayList();
        }

        public AggregateRenderer(XYPlot plot, ColourSeries colours) {
            Measurement[] src = new Measurement[]{};
            XYDataset data = plot.getDataset();
            this.colours = colours.colors(data.getSeriesCount());
            int serie = 0;
            while (serie < data.getSeriesCount()) {
                src = this.merge(src, data, serie);
                ++serie;
            }
            double maxValue = 0.01;
            Measurement[] measurementArray = src;
            int n = src.length;
            int n2 = 0;
            while (n2 < n) {
                Measurement measure = measurementArray[n2];
                maxValue = Math.max(maxValue, measure.value);
                ++n2;
            }
            plot.getRangeAxis().setRange(0.0, maxValue);
        }

        private Measurement[] convert(XYDataset dataset, int series) {
            int size = dataset.getItemCount(series);
            Measurement[] result = new Measurement[size];
            int ctr = 0;
            while (ctr < size) {
                Measurement newMeasure;
                long x = dataset.getX(series, ctr).longValue();
                double y = dataset.getY(series, ctr).doubleValue();
                result[ctr] = newMeasure = new Measurement(x, y);
                ++ctr;
            }
            return result;
        }

        private Measurement[] merge(Measurement[] source, XYDataset dataset, int series) {
            return this.merge(source, this.convert(dataset, series));
        }

        private double findPastFit(Measurement[] pool, int start, long referenceMoment) {
            int prevCtr = start;
            while (prevCtr >= 0 && referenceMoment < pool[prevCtr].when) {
                --prevCtr;
            }
            double correction = prevCtr < 0 ? 0.0 : pool[prevCtr].value;
            return correction;
        }

        private Measurement[] merge(Measurement[] source, Measurement[] target) {
            ArrayList<Measurement> measurements = new ArrayList<Measurement>();
            int srcDataCtr = 0;
            int newDataCtr = 0;
            int newItems = target.length;
            while (srcDataCtr < source.length && newDataCtr < newItems) {
                double value;
                Measurement mergeMeasure;
                long sampleNewData = target[newDataCtr].when;
                double sampleValueNewData = target[newDataCtr].value;
                long srcMoment = source[srcDataCtr].when;
                double srcValue = source[srcDataCtr].value;
                if (sampleNewData == srcMoment) {
                    mergeMeasure = new Measurement(srcMoment, sampleValueNewData + srcValue);
                    ++newDataCtr;
                    ++srcDataCtr;
                } else if (sampleNewData < srcMoment) {
                    value = sampleValueNewData + this.findPastFit(source, srcDataCtr, sampleNewData);
                    mergeMeasure = new Measurement(sampleNewData, value);
                    ++newDataCtr;
                } else {
                    value = srcValue + this.findPastFit(target, newDataCtr, source[srcDataCtr].when);
                    mergeMeasure = new Measurement(srcMoment, value);
                    ++srcDataCtr;
                }
                measurements.add(mergeMeasure);
            }
            while (srcDataCtr < source.length) {
                measurements.add(source[srcDataCtr]);
                ++srcDataCtr;
            }
            while (newDataCtr < newItems) {
                measurements.add(target[newDataCtr]);
                ++newDataCtr;
            }
            Measurement[] result = new Measurement[measurements.size()];
            return measurements.toArray(result);
        }

        public void drawItem(Graphics2D graphics, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
            if (item == 0) {
                boolean isLastSeries;
                this.pastMeasures = this.merge(this.pastMeasures, dataset, series);
                int NCLOSURE = 2;
                int[] xPoints = new int[this.pastMeasures.length + NCLOSURE];
                int[] yPoints = new int[this.pastMeasures.length + NCLOSURE];
                double minDomain = domainAxis.getRange().getLowerBound();
                double maxDomain = domainAxis.getRange().getUpperBound();
                double minImage = rangeAxis.getRange().getLowerBound();
                double maxImage = rangeAxis.getRange().getUpperBound();
                double domainSize = maxDomain - minDomain;
                double imageSize = maxImage - minImage;
                double pxWidth = dataArea.getWidth();
                double pxHeight = dataArea.getHeight();
                int itemCtr = 0;
                while (itemCtr < this.pastMeasures.length) {
                    long when = this.pastMeasures[itemCtr].when;
                    double value = this.pastMeasures[itemCtr].value;
                    double x = dataArea.getX() + pxWidth * ((double)when - minDomain) / domainSize;
                    double ymin = pxHeight + (dataArea.getY() - pxHeight * (value - minImage) / imageSize);
                    xPoints[itemCtr] = (int)x;
                    yPoints[itemCtr] = (int)ymin;
                    ++itemCtr;
                }
                xPoints[xPoints.length - 2] = (int)dataArea.getMaxX();
                yPoints[yPoints.length - 2] = (int)dataArea.getMaxY();
                xPoints[xPoints.length - 1] = (int)dataArea.getMinX();
                yPoints[yPoints.length - 1] = (int)dataArea.getMaxY();
                this.storeReducedPolygon(xPoints, yPoints);
                boolean bl = isLastSeries = series == dataset.getSeriesCount() - 1;
                if (isLastSeries) {
                    int ctr = this.xCors.size() - 1;
                    while (ctr >= 0) {
                        graphics.setColor(this.colours.get(ctr));
                        graphics.fillPolygon(this.xCors.get(ctr), this.yCors.get(ctr), this.yCors.get(ctr).length);
                        --ctr;
                    }
                    this.xCors.clear();
                    this.yCors.clear();
                    this.pastMeasures = null;
                }
            }
        }

        private void storeReducedPolygon(int[] xPoints, int[] yPoints) {
            ArrayList<Integer> xCompressed = new ArrayList<Integer>();
            ArrayList<Integer> yCompressed = new ArrayList<Integer>();
            xCompressed.add(xPoints[0]);
            yCompressed.add(yPoints[0]);
            int ctr = 1;
            while (ctr < xPoints.length) {
                if (xPoints[ctr - 1] != xPoints[ctr] || yPoints[ctr - 1] != yPoints[ctr]) {
                    xCompressed.add(xPoints[ctr]);
                    yCompressed.add(yPoints[ctr]);
                }
                ++ctr;
            }
            xPoints = new int[xCompressed.size()];
            yPoints = new int[yCompressed.size()];
            ctr = 0;
            while (ctr < xCompressed.size()) {
                xPoints[ctr] = (Integer)xCompressed.get(ctr);
                yPoints[ctr] = (Integer)yCompressed.get(ctr);
                ++ctr;
            }
            this.xCors.add(xPoints);
            this.yCors.add(yPoints);
        }

        public Paint getSeriesPaint(int series) {
            return this.colours.get(series);
        }

        public Shape getSeriesShape(int series) {
            return new Rectangle(7, 7);
        }

        public Paint getSeriesOutlinePaint(int arg0) {
            return new Color(0, 0, 0, 0);
        }

        public int getPassCount() {
            return 1;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof AggregateRenderer) {
                AggregateRenderer oth = (AggregateRenderer)obj;
                return oth.hashCode() == this.hashCode();
            }
            return false;
        }

        public int hashCode() {
            return this.pastMeasures.hashCode() + this.xCors.hashCode() + this.yCors.hashCode();
        }

        private static class Measurement
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final long when;
            private final double value;

            public Measurement(long when, double value) {
                this.when = when;
                this.value = value;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj instanceof Measurement) {
                    Measurement oth = (Measurement)obj;
                    return oth.value == this.value && oth.when == this.when;
                }
                return false;
            }

            public int hashCode() {
                return (int)(this.when + (this.when >> 32) + Double.doubleToLongBits(this.value));
            }

            public String toString() {
                return String.valueOf(this.value) + " @ " + this.when;
            }
        }
    }

    private static final class ColourSeries
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long seed;

        public ColourSeries(long seed) {
            this.seed = seed;
        }

        public ArrayList<Color> colors(int count) {
            Random rand = new Random(this.seed);
            ArrayList<Color> result = new ArrayList<Color>();
            float[] gg = Color.RGBtoHSB(0, 174, 239, null);
            Color start = Color.getHSBColor(gg[0], 0.9f, 0.75f);
            result.add(start);
            float previous = gg[0];
            int ctr = result.size();
            while (ctr < count) {
                float next = 0.0f;
                while ((double)Math.abs((next = rand.nextFloat()) - previous) < 0.2) {
                }
                Color color = Color.getHSBColor(next, 0.9f, 0.75f);
                result.add(color);
                previous = next;
                ++ctr;
            }
            return result;
        }
    }
}

