/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.chartCustomizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.DomainOrder;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;

class CompressedTimeSeries
implements XYDataset,
Serializable {
    private static final long serialVersionUID = 1L;
    private long[][] seriesX;
    private double[][] seriesY;
    private List<Comparable<?>> keys;
    private DomainOrder order;

    public CompressedTimeSeries() {
    }

    private CompressedTimeSeries(TimeSeriesCollection data) {
        this.seriesX = new long[data.getSeriesCount()][];
        this.seriesY = new double[data.getSeriesCount()][];
        this.keys = new ArrayList();
        this.order = data.getDomainOrder();
        int count = data.getSeriesCount();
        int ctr = 0;
        while (ctr < count) {
            TimeSeries orig = data.getSeries(ctr);
            this.keys.add(orig.getKey());
            int nItems = orig.getItemCount();
            long[] x = new long[nItems];
            double[] y = new double[nItems];
            int tctr = 0;
            while (tctr < nItems) {
                TimeSeriesDataItem v = orig.getDataItem(tctr);
                if (v.getValue() != null) {
                    x[tctr] = data.getX(ctr, tctr).longValue();
                    y[tctr] = v.getValue().doubleValue();
                }
                ++tctr;
            }
            orig.clear();
            this.seriesX[ctr] = x;
            this.seriesY[ctr] = y;
            ++ctr;
        }
    }

    public static void replaceData(XYPlot plot) {
        int ctr = 0;
        while (ctr < plot.getDatasetCount()) {
            XYDataset collection = plot.getDataset(ctr);
            if (collection instanceof TimeSeriesCollection) {
                CompressedTimeSeries compressed = new CompressedTimeSeries((TimeSeriesCollection)collection);
                plot.setDataset(ctr, (XYDataset)compressed);
                ValueAxis ax = plot.getDomainAxis(ctr);
                if (ax != null) {
                    ax.setAutoRange(true);
                    ax.configure();
                    long min = compressed.getMin();
                    long max = compressed.getMax();
                    Range r = new Range((double)min, (double)max);
                    ax.setRange(r);
                }
            }
            plot.configureDomainAxes();
            ++ctr;
        }
    }

    public long getMax() {
        long maxV = Long.MIN_VALUE;
        long[][] lArray = this.seriesX;
        int n = this.seriesX.length;
        int n2 = 0;
        while (n2 < n) {
            long moment;
            long[] domain = lArray[n2];
            boolean hasData = false;
            long[] lArray2 = domain;
            int n3 = domain.length;
            int n4 = 0;
            while (n4 < n3) {
                moment = lArray2[n4];
                boolean bl = hasData = moment != 0L;
                if (hasData) break;
                ++n4;
            }
            if (hasData) {
                lArray2 = domain;
                n3 = domain.length;
                n4 = 0;
                while (n4 < n3) {
                    moment = lArray2[n4];
                    maxV = Math.max(maxV, moment);
                    ++n4;
                }
            }
            ++n2;
        }
        return maxV;
    }

    public long getMin() {
        long minV = Long.MAX_VALUE;
        long[][] lArray = this.seriesX;
        int n = this.seriesX.length;
        int n2 = 0;
        while (n2 < n) {
            long moment;
            long[] domain = lArray[n2];
            boolean hasData = false;
            long[] lArray2 = domain;
            int n3 = domain.length;
            int n4 = 0;
            while (n4 < n3) {
                moment = lArray2[n4];
                boolean bl = hasData = moment != 0L;
                if (hasData) break;
                ++n4;
            }
            if (hasData) {
                lArray2 = domain;
                n3 = domain.length;
                n4 = 0;
                while (n4 < n3) {
                    moment = lArray2[n4];
                    minV = Math.min(minV, moment);
                    ++n4;
                }
            }
            ++n2;
        }
        return minV;
    }

    public int getSeriesCount() {
        return this.seriesX.length;
    }

    public Comparable getSeriesKey(int idx) {
        return this.keys.get(idx);
    }

    public int indexOf(Comparable key) {
        return this.keys.indexOf(key);
    }

    public void addChangeListener(DatasetChangeListener arg0) {
    }

    public DatasetGroup getGroup() {
        return null;
    }

    public void removeChangeListener(DatasetChangeListener arg0) {
    }

    public void setGroup(DatasetGroup arg0) {
    }

    public DomainOrder getDomainOrder() {
        return this.order;
    }

    public int getItemCount(int ctr) {
        return this.seriesX[ctr].length;
    }

    public Number getX(int s, int ctr) {
        return this.seriesX[s][ctr];
    }

    public double getXValue(int s, int ctr) {
        return this.seriesX[s][ctr];
    }

    public Number getY(int s, int ctr) {
        return this.seriesY[s][ctr];
    }

    public double getYValue(int s, int ctr) {
        return this.seriesY[s][ctr];
    }
}

