/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.chartCustomizer;

import com.excentis.products.byteblower.report.generator.jasper.chartCustomizer.CompressedTimeSeries;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartCustomizer;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;

public class LatencyChart
implements JRChartCustomizer,
Serializable {
    private static final long serialVersionUID = 1L;

    public void customize(JFreeChart chartImage, JRChart chartLocation) {
        XYPlot plot = chartImage.getXYPlot();
        CompressedTimeSeries.replaceData(plot);
        this.fillLegend(plot);
        LatencyRenderer render = new LatencyRenderer(plot.getRenderer());
        plot.setRenderer((XYItemRenderer)render);
    }

    private LegendItem humanLegend(LegendItem src, boolean shortform) {
        if (shortform) {
            String label = src.getLabel();
            String shortLabel = label.substring(label.lastIndexOf(45) + 1);
            LegendItem shortForm = new LegendItem(shortLabel, shortLabel, src.getToolTipText(), src.getURLText(), src.getLine(), src.getLineStroke(), src.getLinePaint());
            return shortForm;
        }
        return src;
    }

    private void fillLegend(XYPlot plot) {
        int nSeriesAPort = 5;
        String postfix = "jitter";
        boolean useShortForm = plot.getLegendItems().getItemCount() / 5 == 1;
        LegendItemCollection legendItems = new LegendItemCollection();
        Iterator it = plot.getLegendItems().iterator();
        LegendItem jitter = null;
        String prefix = "";
        while (it.hasNext()) {
            LegendItem legend = (LegendItem)it.next();
            String label = legend.getLabel();
            if (!label.contains("jitter")) {
                legendItems.add(this.humanLegend(legend, useShortForm));
                continue;
            }
            int endPrefix = label.lastIndexOf("jitter");
            prefix = label.substring(0, endPrefix);
            jitter = legend;
        }
        if (jitter != null) {
            if (useShortForm) {
                prefix = "";
            }
            String jitterText = String.valueOf(prefix) + "jitter";
            LegendItem jitterItem = new LegendItem(jitterText);
            jitterItem.setSeriesKey(jitter.getSeriesKey());
            jitterItem.setFillPaint(jitter.getFillPaint());
            jitterItem.setLinePaint(jitter.getLinePaint());
            legendItems.add(jitterItem);
        }
        plot.setFixedLegendItems(legendItems);
    }

    private static class LatencyRenderer
    extends AbstractXYItemRenderer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private XYItemRenderer primaryRender;

        public LatencyRenderer(XYItemRenderer source) {
            this.primaryRender = source;
        }

        public void drawItem(Graphics2D graphics, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
            boolean firstCall;
            if (this.primaryRender == null) {
                return;
            }
            boolean bl = firstCall = pass == 0 && series == 0 && item == 0;
            if (firstCall) {
                this.drawJitterBand(graphics, dataArea, domainAxis, rangeAxis, dataset);
            }
            if (pass > 0) {
                this.primaryRender.drawItem(graphics, state, dataArea, info, plot, domainAxis, rangeAxis, dataset, series, item, crosshairState, pass - 1);
            }
        }

        private void drawJitterBand(Graphics2D graphics, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset) {
            int notFound = Integer.MIN_VALUE;
            int plus = Integer.MIN_VALUE;
            int min = Integer.MIN_VALUE;
            int ctr = 0;
            while (ctr < dataset.getSeriesCount()) {
                Comparable oKey = dataset.getSeriesKey(ctr);
                if (oKey instanceof String && ((String)((Object)oKey)).endsWith("jitter_plus")) {
                    plus = ctr;
                } else if (oKey instanceof String && ((String)((Object)oKey)).endsWith("jitter_minus")) {
                    min = ctr;
                }
                ++ctr;
            }
            if (plus != Integer.MIN_VALUE && min != Integer.MIN_VALUE && dataset.getItemCount(plus) == dataset.getItemCount(min)) {
                int items = dataset.getItemCount(plus);
                int[] xPoints = new int[items * 2];
                int[] yPoints = new int[items * 2];
                double minDomain = domainAxis.getRange().getLowerBound();
                double maxDomain = domainAxis.getRange().getUpperBound();
                double minImage = rangeAxis.getRange().getLowerBound();
                double maxImage = rangeAxis.getRange().getUpperBound();
                double domainSize = maxDomain - minDomain;
                double imageSize = maxImage - minImage;
                double pxWidth = dataArea.getWidth();
                double pxHeight = dataArea.getHeight();
                int itemCtr = 0;
                while (itemCtr < items) {
                    double x = dataArea.getX() + pxWidth * (dataset.getX(min, itemCtr).doubleValue() - minDomain) / domainSize;
                    double ymin = pxHeight + (dataArea.getY() - pxHeight * (dataset.getY(min, itemCtr).doubleValue() - minImage) / imageSize);
                    double yplus = pxHeight + (dataArea.getY() - pxHeight * (dataset.getY(plus, itemCtr).doubleValue() - minImage) / imageSize);
                    int idxMax = 2 * items - (1 + itemCtr);
                    xPoints[itemCtr] = (int)x;
                    yPoints[itemCtr] = (int)ymin;
                    xPoints[idxMax] = (int)x;
                    yPoints[idxMax] = (int)yplus;
                    ++itemCtr;
                }
                Paint paint = this.primaryRender.getSeriesPaint(min);
                graphics.setPaint(paint);
                graphics.fillPolygon(xPoints, yPoints, xPoints.length);
            }
        }

        public int getPassCount() {
            return this.primaryRender.getPassCount() + 1;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LatencyRenderer) {
                LatencyRenderer oth = (LatencyRenderer)obj;
                return this.primaryRender != null && this.primaryRender.equals(oth.primaryRender);
            }
            return false;
        }

        public int hashCode() {
            int base = 19;
            if (this.primaryRender != null) {
                return base + this.primaryRender.hashCode();
            }
            return base;
        }
    }
}

