/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.chartCustomizer;

import com.excentis.products.byteblower.report.generator.jasper.chartCustomizer.CompressedTimeSeries;
import com.excentis.products.byteblower.report.generator.jasper.chartCustomizer.ProxyRender;
import java.awt.Color;
import java.awt.Paint;
import java.util.WeakHashMap;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartCustomizer;
import net.sf.jasperreports.engine.JRElementGroup;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.time.TimeSeriesCollection;

public class MultiAxisChart
implements JRChartCustomizer {
    private static final Color fullorange = new Color(255, 160, 30);
    private static final Color darkorange = new Color(175, 100, 0);
    private static final Color green = new Color(0, 166, 80);
    private static final Color excentisblue = new Color(0, 174, 239);
    private static final Color hardblue = new Color(0, 0, 200);
    private static WeakHashMap<JRElementGroup, ProxyRender> proxies = new WeakHashMap();

    static ProxyRender getRender(JRElementGroup group) {
        return proxies.get(group);
    }

    public void customize(JFreeChart chartImage, JRChart chartLocation) {
        TimeSeriesCollection collection;
        XYPlot plot = chartImage.getXYPlot();
        boolean hasTX = plot.getDatasetCount() >= 2 && plot.getDataset(1).getSeriesCount() >= 3;
        XYLineAndShapeRenderer renderer0 = (XYLineAndShapeRenderer)plot.getRenderer(0);
        XYLineAndShapeRenderer renderer1 = (XYLineAndShapeRenderer)plot.getRenderer(1);
        XYLineAndShapeRenderer renderer2 = (XYLineAndShapeRenderer)plot.getRenderer(2);
        renderer0.setDrawSeriesLineAsPath(true);
        renderer1.setDrawSeriesLineAsPath(true);
        renderer2.setDrawSeriesLineAsPath(true);
        renderer0.setSeriesPaint(0, (Paint)excentisblue);
        renderer0.setSeriesPaint(1, (Paint)hardblue);
        ValueAxis rttAxis = plot.getRangeAxis(1);
        Range range = this.optimizeRange(rttAxis.getRange());
        rttAxis.setRange(range);
        renderer1.setSeriesPaint(2, (Paint)green);
        ValueAxis winAxis = plot.getRangeAxis(2);
        boolean useTransmitWindow = false;
        useTransmitWindow = true;
        if (plot.getDatasetCount() > 0 && (collection = (TimeSeriesCollection)plot.getDataset(0)).getSeriesCount() > 3) {
            collection.getSeries(2).clear();
            collection.getSeries(3).clear();
        }
        if (plot.getDatasetCount() > 1 && (collection = (TimeSeriesCollection)plot.getDataset(1)).getSeriesCount() > 3) {
            collection.getSeries(0).clear();
            collection.getSeries(3).clear();
        }
        if (plot.getDatasetCount() > 2 && (collection = (TimeSeriesCollection)plot.getDataset(2)).getSeriesCount() > 3) {
            collection.getSeries(0).clear();
            collection.getSeries(1).clear();
            collection.getSeries(3).clear();
        }
        range = winAxis.getRange();
        LogarithmicAxis newAxis = new LogarithmicAxis(winAxis.getLabel());
        newAxis.setAllowNegativesFlag(true);
        newAxis.setLabelPaint(winAxis.getLabelPaint());
        newAxis.setLabelFont(winAxis.getLabelFont());
        newAxis.setTickLabelFont(winAxis.getTickLabelFont());
        winAxis = newAxis;
        plot.setRangeAxis(2, winAxis);
        range = this.optimizeRange(winAxis.getRange());
        winAxis.setRange(range);
        renderer2.setSeriesPaint(1, (Paint)fullorange);
        renderer2.setSeriesPaint(2, (Paint)darkorange);
        CompressedTimeSeries.replaceData(plot);
        if (!hasTX) {
            plot.setRenderers(new XYItemRenderer[]{renderer0});
            ValueAxis[] axis = new ValueAxis[]{plot.getRangeAxis(0)};
            Range domainRange = plot.getDomainAxis().getRange();
            double upper = domainRange.getUpperBound() + (domainRange.getUpperBound() - domainRange.getLowerBound()) * 0.135;
            plot.getDomainAxis().setRange(new Range(domainRange.getLowerBound(), upper));
            plot.clearRangeAxes();
            plot.setRangeAxes(axis);
            plot.configureRangeAxes();
            plot.configureDomainAxes();
        }
        LegendItemCollection legendItems = plot.getLegendItems();
        LegendItemCollection newItems = new LegendItemCollection();
        int itemCount = legendItems.getItemCount();
        if (itemCount > 0) {
            newItems.add(legendItems.get(0));
        }
        if (itemCount > 1) {
            newItems.add(legendItems.get(1));
        }
        if (itemCount > 6 && hasTX) {
            newItems.add(legendItems.get(6));
        }
        if (itemCount > 8 && hasTX && !useTransmitWindow) {
            newItems.add(legendItems.get(8));
        }
        if (itemCount > 10 && hasTX) {
            newItems.add(legendItems.get(10));
        }
        if (hasTX) {
            LegendItem retransmissions = new LegendItem("Retransmissions");
            retransmissions.setFillPaint((Paint)Color.gray);
            retransmissions.setLabelPaint(legendItems.get(0).getLabelPaint());
            retransmissions.setLabelFont(legendItems.get(0).getLabelFont());
            newItems.add(retransmissions);
        }
        plot.setFixedLegendItems(newItems);
        XYItemRenderer[] renderers = new XYItemRenderer[plot.getRendererCount()];
        int ctr = 0;
        while (ctr < renderers.length) {
            ProxyRender proxy = new ProxyRender(plot.getRenderer(ctr));
            proxies.put(chartLocation.getElementGroup(), proxy);
            renderers[ctr] = proxy;
            ++ctr;
        }
        plot.setRenderers(renderers);
    }

    private Range optimizeRange(Range range) {
        double upper = range.getUpperBound();
        if (upper < 1.0) {
            return range;
        }
        int timesten = -1;
        double newUpper = upper;
        while (newUpper >= 1.0) {
            newUpper /= 10.0;
            ++timesten;
        }
        int scale = (int)Math.pow(10.0, timesten);
        if (scale == 0) {
            return range;
        }
        newUpper = (int)upper / scale * scale + scale;
        return new Range(range.getLowerBound(), newUpper);
    }
}

