/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.chartCustomizer;

import com.excentis.products.byteblower.report.generator.jasper.chartCustomizer.MultiAxisChart;
import com.excentis.products.byteblower.report.generator.jasper.chartCustomizer.NoAxisRenderer;
import com.excentis.products.byteblower.report.generator.jasper.chartCustomizer.ProxyRender;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartCustomizer;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;

public class Retransmissions
implements JRChartCustomizer,
Serializable {
    private static final long serialVersionUID = 1L;

    public void customize(JFreeChart chartImage, JRChart chartLocation) {
        double maxBucket;
        double minBucket;
        List<Bucket> srcBuckets;
        XYPlot plot = chartImage.getXYPlot();
        ProxyRender other = MultiAxisChart.getRender(chartLocation.getElementGroup());
        XYDataset retrans = plot.getDataset();
        boolean hasTX = plot.getDataset(0).getSeriesCount() >= 4;
        ValueAxis srcAxis = plot.getDomainAxis();
        double lower = srcAxis.getLowerBound();
        double upper = srcAxis.getUpperBound();
        int maxbins = 200;
        List<Bucket> baseData = this.collectBuckets(retrans);
        double max = 0.0;
        if (baseData.isEmpty()) {
            srcBuckets = baseData;
            minBucket = 0.0;
            maxBucket = 1.0;
        } else if (hasTX && baseData.size() < 200 && !baseData.isEmpty()) {
            double dataMinDomain;
            srcBuckets = baseData;
            Bucket lastBucket = srcBuckets.get(srcBuckets.size() - 1);
            double dataMaxDomain = lastBucket.start + lastBucket.width;
            minBucket = dataMinDomain = srcBuckets.get((int)0).start;
            maxBucket = dataMaxDomain;
            for (Bucket b : srcBuckets) {
                max = Math.max(max, b.value);
            }
        } else {
            minBucket = lower;
            maxBucket = upper;
            int bins = 200;
            double binWidth = (upper - lower) / (double)bins;
            double currentBucket = lower;
            ArrayList<Bucket> otherBuckets = new ArrayList<Bucket>();
            int sampleCtr = 0;
            int bucketCtr = 0;
            while (bucketCtr < bins) {
                double part;
                Bucket b;
                double bucketEnd = currentBucket + binWidth;
                double value = 0.0;
                while (sampleCtr < baseData.size() && baseData.get(sampleCtr).end() < currentBucket) {
                    ++sampleCtr;
                }
                while (sampleCtr < baseData.size() && baseData.get((int)sampleCtr).start < currentBucket) {
                    b = baseData.get(sampleCtr);
                    part = (b.end() - currentBucket) / b.width;
                    value += b.value * part;
                    ++sampleCtr;
                }
                while (sampleCtr < baseData.size() && baseData.get(sampleCtr).end() < bucketEnd) {
                    b = baseData.get(sampleCtr);
                    value += b.value;
                    ++sampleCtr;
                }
                if (sampleCtr < baseData.size() && baseData.get((int)sampleCtr).start < bucketEnd) {
                    b = baseData.get(sampleCtr);
                    part = (bucketEnd - b.start) / b.width;
                    value += b.value * part;
                }
                otherBuckets.add(new Bucket(currentBucket, bucketEnd - currentBucket, value));
                max = Math.max(max, value);
                currentBucket = bucketEnd;
                ++bucketCtr;
            }
            srcBuckets = otherBuckets;
        }
        plot.getRangeAxis().setUpperBound(Math.max(max, 5.0));
        plot.getRangeAxis().setLabel("packets");
        this.clearTimeAxis(plot, srcAxis);
        plot.setFixedLegendItems(new LegendItemCollection());
        Object render = hasTX ? new ProxyRender((XYItemRenderer)new BucketsRenderer(other, srcBuckets, minBucket, maxBucket)) : new InvalidatedBuckets();
        plot.setRenderer((XYItemRenderer)render);
    }

    private void clearTimeAxis(XYPlot plot, ValueAxis srcAxis) {
        NoAxisRenderer emptyAxis = new NoAxisRenderer(srcAxis);
        plot.setDomainAxis((ValueAxis)emptyAxis);
        emptyAxis.configure();
        emptyAxis.setRange(0.0, 1.0);
    }

    private List<Bucket> collectBuckets(XYDataset retrans) {
        if (retrans.getSeriesCount() < 4) {
            return Collections.emptyList();
        }
        int start = 0;
        int end = retrans.getItemCount(3);
        while (start < end) {
            if (retrans.getY(3, start).doubleValue() != 0.0) break;
            ++start;
        }
        while (end > start) {
            if (retrans.getY(3, end - 1).doubleValue() == 0.0) {
                --end;
                continue;
            }
            ++end;
            break;
        }
        ArrayList<Bucket> srcBuckets = new ArrayList<Bucket>();
        double previous = 1.0E9;
        int ctr = start;
        while (ctr < end) {
            double sampleBucketWidth;
            double x = retrans.getXValue(3, ctr);
            double y = retrans.getY(3, ctr).doubleValue();
            previous = sampleBucketWidth = ctr + 1 < retrans.getItemCount(3) ? retrans.getXValue(3, ctr + 1) - x : previous;
            srcBuckets.add(new Bucket(x, sampleBucketWidth, y));
            ++ctr;
        }
        return srcBuckets;
    }

    static class Bucket
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final double start;
        final double width;
        final double value;

        public Bucket(double start, double widht, double value) {
            this.start = start;
            this.width = widht;
            this.value = value;
        }

        double end() {
            return this.start + this.width;
        }

        public String toString() {
            String format = "[%02f,%02f]: %02f";
            return String.format(format, this.start, this.start + this.width, this.value);
        }
    }

    private static class BucketsRenderer
    extends AbstractXYItemRenderer {
        private final double minBucket;
        private final ProxyRender other;
        private final double maxBucket;
        private final List<Bucket> srcBuckets;
        private static final long serialVersionUID = 1L;
        private boolean once = true;

        private BucketsRenderer(ProxyRender other, List<Bucket> srcBuckets, double minBucket, double maxBucket) {
            this.minBucket = minBucket;
            this.other = other;
            this.maxBucket = maxBucket;
            this.srcBuckets = srcBuckets;
        }

        private double normalize(double value, double min, double max) {
            return (value - min) / (max - min);
        }

        public void drawItem(Graphics2D graphics, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
            if (this.once) {
                this.once = false;
                this.drawBuckets(this.other, this.srcBuckets, this.minBucket, this.maxBucket, graphics, rangeAxis);
            }
        }

        private void drawBuckets(ProxyRender baseTcpRender, List<Bucket> srcBuckets, double minBucket, double maxBucket, Graphics2D graphics, ValueAxis rangeAxis) {
            Rectangle2D tcpDrawing = baseTcpRender.getDrawingLocation();
            if (tcpDrawing == null) {
                return;
            }
            double TCP_GRAPH_WIDTH = tcpDrawing.getWidth();
            double TCP_OFFSET = tcpDrawing.getMinX();
            double upper = baseTcpRender.getMaximumDomain();
            double lower = baseTcpRender.getMinimumDomain();
            double min_corrected = TCP_GRAPH_WIDTH * this.normalize(minBucket, lower, upper);
            double max_corrected = TCP_GRAPH_WIDTH * this.normalize(maxBucket, lower, upper);
            double upperRange = rangeAxis.getUpperBound();
            double pixelWidth = (max_corrected - min_corrected) / (double)srcBuckets.size();
            double barWidht = Math.max(pixelWidth - 1.0, 1.0);
            graphics.setColor(Color.gray);
            int ctr = 0;
            while (ctr < srcBuckets.size()) {
                Bucket bucket = srcBuckets.get(ctr);
                if (bucket.value > 0.0) {
                    int x = (int)(TCP_OFFSET + TCP_GRAPH_WIDTH * this.normalize(bucket.start, lower, upper));
                    double y = 42.0;
                    int barHeigth = (int)Math.ceil(y * bucket.value / upperRange);
                    graphics.fillRect(x, (int)(y - (double)barHeigth), (int)barWidht, barHeigth);
                }
                ++ctr;
            }
        }
    }

    private static class InvalidatedBuckets
    extends AbstractXYItemRenderer {
        private static final long serialVersionUID = 1L;
        private boolean once = true;

        private InvalidatedBuckets() {
        }

        public void drawItem(Graphics2D graphics, XYItemRendererState arg1, Rectangle2D dataArea, PlotRenderingInfo arg3, XYPlot arg4, ValueAxis arg5, ValueAxis arg6, XYDataset arg7, int arg8, int arg9, CrosshairState arg10, int arg11) {
            if (this.once) {
                this.once = false;
                this.invalidatedArea(graphics, dataArea);
            }
        }

        private void invalidatedArea(Graphics2D graphics, Rectangle2D dataArea) {
            graphics.setColor(new Color(10, 10, 10, 10));
            graphics.fillRect((int)dataArea.getMinX(), (int)dataArea.getMinY(), (int)dataArea.getWidth(), (int)dataArea.getHeight());
            graphics.setColor(Color.LIGHT_GRAY);
            int ctr = -20;
            while ((double)ctr < dataArea.getMaxX()) {
                graphics.drawLine(ctr, (int)dataArea.getMaxY(), ctr + 40, (int)dataArea.getMinY());
                ctr += 20;
            }
        }
    }
}

