/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.datasource;

import com.excentis.products.byteblower.report.generator.jasper.datasource.ByteBlowerReportDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.ThroughputSnapshot;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.chart.GenerateAggregateRxThroughputResultsOverTimeCharts;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.fill.JRFillField;

public class AggregateRxHttpThroughputRotChartDataSource
extends ByteBlowerReportDataSource {
    private Queue<NamedIterator<ThroughputSnapshot>> series = new LinkedList<NamedIterator<ThroughputSnapshot>>();
    protected ThroughputSnapshot current = null;
    private String portName;
    private GenerateAggregateRxThroughputResultsOverTimeCharts generator;
    protected long ms;

    public AggregateRxHttpThroughputRotChartDataSource(GenerateAggregateRxThroughputResultsOverTimeCharts generator, String portName) {
        this.generator = generator;
        this.portName = portName;
    }

    private NamedIterator<ThroughputSnapshot> getCurrentSeries() {
        return this.series.peek();
    }

    public void addSeries(String name, Iterator<ThroughputSnapshot> it) {
        NamedIterator<ThroughputSnapshot> tt = new NamedIterator<ThroughputSnapshot>(name, it);
        this.series.add(tt);
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        ThroughputSnapshot snapshot = this.current;
        JRFillField fillField = (JRFillField)jrField;
        if (snapshot == null) {
            return null;
        }
        String fieldName = fillField.getName();
        if ("results_over_time_series".equals(fieldName)) {
            return this.getCurrentSeries().name();
        }
        if ("results_over_time_time".equals(fieldName)) {
            Long ms = this.calculateSnapshotTimeInMs(snapshot);
            return new Date(ms);
        }
        if ("results_over_time_throughput".equals(fieldName)) {
            return snapshot.getConvertedThroughPut(this.generator.getDataRateUnit());
        }
        if ("results_over_time_chart_name".equals(fieldName)) {
            return this.portName;
        }
        if ("data_unit".equals(fieldName)) {
            return this.generator.getDataRateUnit().toString();
        }
        if ("data_type".equals(fieldName)) {
            return "RX Bitrate";
        }
        return null;
    }

    protected long calculateSnapshotTimeInMs(ThroughputSnapshot snapshot) {
        return snapshot.getCorrectedSnapshotTimeMs();
    }

    public boolean next() throws JRException {
        while (!this.series.isEmpty()) {
            NamedIterator<ThroughputSnapshot> it = this.getCurrentSeries();
            if (it.hasNext()) {
                this.current = it.next();
                return true;
            }
            this.series.poll();
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.current == null || this.series.isEmpty() || !this.series.peek().hasNext();
    }

    @Override
    public Class<?> getJRDataSourceClass() {
        return this.getClass();
    }

    public void markAsFirst() {
    }

    private class NamedIterator<T>
    implements Iterator<T> {
        private final String name;
        private final Iterator<T> values;

        public NamedIterator(String name, Iterator<T> it) {
            this.name = name;
            this.values = it;
        }

        @Override
        public boolean hasNext() {
            return this.values.hasNext();
        }

        @Override
        public T next() {
            return this.values.next();
        }

        @Override
        public void remove() {
            this.values.remove();
        }

        public String name() {
            return this.name;
        }
    }
}

