/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.datasource;

import com.excentis.products.byteblower.report.generator.jasper.datasource.PagingQueryDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.SnapShotOffset;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeSubReports;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatencySnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbLatencySnapshotReader;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.fill.JRFillField;

public class FbLatencyRotDataSource
extends PagingQueryDataSource<FbLatencySnapshot> {
    private String flowName;
    private String sourceName;
    private String destinationName;

    public FbLatencyRotDataSource(EntityManager entityManager, GenerateResultsOverTimeSubReports<?> generator, String flowName, String sourceName, String destinationName, Map<String, TypedQuery<FbLatencySnapshot>> queryMap) {
        super(entityManager, generator, queryMap);
        this.flowName = flowName;
        this.sourceName = sourceName;
        this.destinationName = destinationName;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        SnapShotOffset offset = this.getCurrentSnapshot();
        FbLatencySnapshotReader reader = EntityReaderFactory.create((FbLatencySnapshot)((FbLatencySnapshot)offset.getSnapshot()));
        JRFillField fillField = (JRFillField)jrField;
        String fieldName = fillField.getName();
        if (fieldName.equals("results_over_time_series")) {
            return this.getSeries();
        }
        if (fieldName.equals("results_over_time_time")) {
            return offset.getTimestampForChart(true);
        }
        if (fieldName.equals("results_over_time_average")) {
            Double val = reader.getLatencyAverage(this.generator.getLatencyUnit());
            return val;
        }
        if (fieldName.equals("results_over_time_minimum")) {
            Double val = reader.getLatencyMinimum(this.generator.getLatencyUnit());
            return val;
        }
        if (fieldName.equals("results_over_time_maximum")) {
            Double val = reader.getLatencyMaximum(this.generator.getLatencyUnit());
            return val;
        }
        if (fieldName.equals("results_over_time_avg_plus_jitter")) {
            Double val = reader.getLatencyAverage(this.generator.getLatencyUnit()) + reader.getJitter(this.generator.getLatencyUnit());
            return val;
        }
        if (fieldName.equals("results_over_time_avg_minus_jitter")) {
            Double val = reader.getLatencyAverage(this.generator.getLatencyUnit()) - reader.getJitter(this.generator.getLatencyUnit());
            return val;
        }
        if (fieldName.equals("results_over_time_chart_name")) {
            return String.valueOf(this.flowName) + "\r\n" + this.destinationName;
        }
        if (fieldName.equals("data_unit")) {
            return this.generator.getLatencyUnit().toString();
        }
        if (fieldName.equals("data_type")) {
            return "Latency";
        }
        if (fieldName.equals("frame_blasting_flow")) {
            return this.flowName;
        }
        if (fieldName.equals("frame_blasting_source")) {
            return this.sourceName;
        }
        if (fieldName.equals("frame_blasting_destination")) {
            return this.destinationName;
        }
        if (fieldName.equals("results_over_time_jitter")) {
            return reader.getJitter(this.generator.getLatencyUnit());
        }
        if (fieldName.equals("results_over_time_time_s")) {
            Date snapshotTime = offset.getTimestampForChart(true);
            String val = new SimpleDateFormat("HH'h 'mm'm 'ss's '").format(snapshotTime);
            return val;
        }
        return null;
    }

    @Override
    protected boolean sameTime(FbLatencySnapshot snapshot, long timestamp) {
        return snapshot.getSnapshotTime() != timestamp;
    }

    @Override
    protected long getSnapshotDuration(FbLatencySnapshot snapshot) {
        return snapshot.getSnapshotDuration();
    }

    @Override
    protected long getSnapshotTime(FbLatencySnapshot snapshot) {
        return snapshot.getSnapshotTime();
    }

    @Override
    protected long getSnapshotResolution(FbLatencySnapshot snapshot) {
        return snapshot.getLatency().getSnapshotResolution();
    }
}

