/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.datasource;

import com.excentis.products.byteblower.report.generator.jasper.datasource.PagingQueryDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.SnapShotOffset;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeSubReports;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTriggerSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbTriggerSnapshotReader;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.fill.JRFillField;

public class FbThroughputRotChartDataSource
extends PagingQueryDataSource<FbTriggerSnapshot> {
    private String flowName;

    public FbThroughputRotChartDataSource(EntityManager entityManager, GenerateResultsOverTimeSubReports<?> generator, String flowName, Map<String, TypedQuery<FbTriggerSnapshot>> queryMap) {
        super(entityManager, generator, queryMap);
        this.flowName = flowName;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        SnapShotOffset offset = this.getCurrentSnapshot();
        FbTriggerSnapshotReader reader = EntityReaderFactory.create((FbTriggerSnapshot)((FbTriggerSnapshot)offset.getSnapshot()));
        JRFillField fillField = (JRFillField)jrField;
        String fieldName = fillField.getName();
        if (fieldName.equals("results_over_time_series")) {
            return this.getSeries();
        }
        if (fieldName.equals("results_over_time_time")) {
            return offset.getTimestampForChart(true);
        }
        if (fieldName.equals("results_over_time_throughput")) {
            Double val = reader.getThroughput(this.generator.getEthernetThroughputType(), this.generator.getDataRateUnit());
            return val;
        }
        if (fieldName.equals("results_over_time_chart_name")) {
            return this.flowName;
        }
        if (fieldName.equals("data_unit")) {
            return this.generator.getDataRateUnit().toString();
        }
        if (fieldName.equals("data_type")) {
            return "Bitrate";
        }
        return null;
    }

    @Override
    protected boolean sameTime(FbTriggerSnapshot snapshot, long timestamp) {
        return snapshot.getSnapshotTime() != timestamp;
    }

    @Override
    protected long getSnapshotDuration(FbTriggerSnapshot snapshot) {
        return snapshot.getSnapshotDuration();
    }

    @Override
    protected long getSnapshotTime(FbTriggerSnapshot snapshot) {
        return snapshot.getSnapshotTime();
    }

    @Override
    protected long getSnapshotResolution(FbTriggerSnapshot snapshot) {
        return snapshot.getTrigger().getSnapshotResolution();
    }
}

