/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.datasource;

import com.excentis.products.byteblower.report.generator.jasper.datasource.ByteBlowerReportDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.PagingQueryDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.SnapShotOffset;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeSubReports;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpSessionReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpSessionSnapshotReader;
import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.fill.JRFillField;

public class HttpThroughputRotChartDataSource
extends PagingQueryDataSource<HttpSessionSnapshot> {
    private final GenerateResultsOverTimeSubReports<HttpFlowInstance> generator;
    private final String flowName;
    private final ThroughputValue picker;

    private HttpThroughputRotChartDataSource(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, String portName, TypedQuery<HttpSessionSnapshot> query, ThroughputValue picker) {
        super(entityManager, generator, portName, query);
        this.generator = generator;
        this.flowName = flowName;
        this.picker = picker;
    }

    public static ByteBlowerReportDataSource rxGoodput(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, String portName, HttpSessionReader httpSessionReader) {
        TypedQuery httpQuery = httpSessionReader.getSnapshotsQuery(entityManager);
        return HttpThroughputRotChartDataSource.rxGoodput(entityManager, generator, flowName, portName, (TypedQuery<HttpSessionSnapshot>)httpQuery);
    }

    public static HttpThroughputRotChartDataSource rxGoodput(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, String portName, TypedQuery<HttpSessionSnapshot> query) {
        return new HttpThroughputRotChartDataSource(entityManager, generator, flowName, portName, query, new RxGoodput());
    }

    public static ByteBlowerReportDataSource txGoodput(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, String portName, HttpSessionReader httpSessionReader) {
        TypedQuery httpQuery = httpSessionReader.getSnapshotsQuery(entityManager);
        return HttpThroughputRotChartDataSource.txGoodput(entityManager, generator, flowName, portName, (TypedQuery<HttpSessionSnapshot>)httpQuery);
    }

    public static HttpThroughputRotChartDataSource txGoodput(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, String portName, TypedQuery<HttpSessionSnapshot> query) {
        return new HttpThroughputRotChartDataSource(entityManager, generator, flowName, portName, query, new TxGoodput());
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        SnapShotOffset offset = this.getCurrentSnapshot();
        HttpSessionSnapshotReader reader = EntityReaderFactory.create((HttpSessionSnapshot)((HttpSessionSnapshot)offset.getSnapshot()));
        JRFillField fillField = (JRFillField)jrField;
        Object fieldValue = null;
        String fieldName = fillField.getName();
        if ("results_over_time_series_1".equals(fieldName)) {
            fieldValue = this.getSeries();
        } else if ("results_over_time_time".equals(fieldName)) {
            fieldValue = offset.getTimestampForChart(true);
        } else if ("results_over_time_throughput".equals(fieldName)) {
            Double val = this.picker.value(reader, this.generator.getDataRateUnit());
            fieldValue = val;
        } else if ("results_over_time_chart_name".equals(fieldName)) {
            fieldValue = this.flowName;
        } else if ("data_unit".equals(fieldName)) {
            fieldValue = this.generator.getDataRateUnit().toString();
        } else if ("data_type".equals(fieldName)) {
            fieldValue = String.valueOf(this.getSeries()) + " Bitrate";
        } else if ("results_over_time_series_2".equals(fieldName)) {
            fieldValue = "RTT @HTTP";
        } else if ("results_over_time_series_3".equals(fieldName)) {
            fieldValue = "Congestion Window @HTTP";
        }
        return fieldValue;
    }

    @Override
    protected boolean sameTime(HttpSessionSnapshot snapshot, long timestamp) {
        return snapshot.getSnapshotTime() != timestamp;
    }

    @Override
    protected long getSnapshotDuration(HttpSessionSnapshot snapshot) {
        return snapshot.getSnapshotDuration();
    }

    @Override
    protected long getSnapshotTime(HttpSessionSnapshot snapshot) {
        return snapshot.getSnapshotTime();
    }

    @Override
    protected long getSnapshotResolution(HttpSessionSnapshot snapshot) {
        return snapshot.getHttpSession().getSnapshotResolution();
    }

    private static class RxGoodput
    implements ThroughputValue {
        private RxGoodput() {
        }

        @Override
        public Double value(HttpSessionSnapshotReader reader, DataRateUnit dataRateUnit) {
            return reader.getRxThroughput(dataRateUnit);
        }
    }

    private static interface ThroughputValue {
        public Double value(HttpSessionSnapshotReader var1, DataRateUnit var2);
    }

    private static class TxGoodput
    implements ThroughputValue {
        private TxGoodput() {
        }

        @Override
        public Double value(HttpSessionSnapshotReader reader, DataRateUnit dataRateUnit) {
            return reader.getTxThroughput(dataRateUnit);
        }
    }
}

