/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.datasource;

import com.excentis.products.byteblower.report.generator.jasper.datasource.ByteBlowerReportDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.SnapShotOffset;
import com.excentis.products.byteblower.report.generator.jasper.datasource.SnapshotCounter;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeSubReports;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.PagingList;
import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import net.sf.jasperreports.engine.JRException;

public abstract class PagingQueryDataSource<SnapShot extends BaseEntity>
extends ByteBlowerReportDataSource {
    private static final int PAGE_SIZE = 100000;
    private Queue<PagingList<SnapShot>> pagingLists = new LinkedList<PagingList<SnapShot>>();
    private int index = -1;
    private double nextIndex = this.index;
    private int totalsize;
    private SnapShotOffset<SnapShot> currentSnapshot = null;
    private PagingList<SnapShot> currentPagingList = null;
    private SerieState serieState = SerieState.START;
    private boolean repeatStartTwice = true;
    private EntityManager entityManager;
    protected GenerateResultsOverTimeSubReports<?> generator;

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$report$generator$jasper$datasource$PagingQueryDataSource$SerieState = PagingQueryDataSource.$SWITCH_TABLE$com$excentis$products$byteblower$report$generator$jasper$datasource$PagingQueryDataSource$SerieState();
    }

    protected PagingQueryDataSource(EntityManager entityManager, GenerateResultsOverTimeSubReports<?> generator, String seriesName, TypedQuery<SnapShot> query) {
        this.generator = generator;
        this.entityManager = entityManager;
        this.addTypedQuery(seriesName, query);
    }

    protected PagingQueryDataSource(EntityManager entityManager, GenerateResultsOverTimeSubReports<?> generator, Map<String, TypedQuery<SnapShot>> queryMap) {
        this.entityManager = entityManager;
        this.generator = generator;
        for (Map.Entry<String, TypedQuery<SnapShot>> entry : queryMap.entrySet()) {
            this.addTypedQuery(entry.getKey(), entry.getValue());
        }
    }

    private void setSerieState(SerieState serieState) {
        this.serieState = serieState;
        if (serieState == SerieState.START) {
            this.repeatStartTwice = true;
        }
    }

    public int getSize() {
        return this.totalsize;
    }

    private void addTypedQuery(String series, TypedQuery<SnapShot> query) {
        PagingList pagingList = new PagingList(this.entityManager, series, query, 100000);
        if (this.currentPagingList == null) {
            this.currentPagingList = pagingList;
        } else {
            this.pagingLists.add(pagingList);
        }
        int size = pagingList.size();
        SnapshotCounter.addCount(size);
        this.totalsize += size;
    }

    @Override
    public Class<?> getJRDataSourceClass() {
        return PagingQueryDataSource.class;
    }

    public boolean next() throws JRException {
        if (this.isEmpty()) {
            return false;
        }
        this.currentSnapshot = this.step();
        boolean hasNext = this.currentSnapshot != null;
        return hasNext;
    }

    private SnapShotOffset<SnapShot> step() {
        switch (this.serieState) {
            case START: {
                return this.getStartDot();
            }
            case PRE: {
                return this.getPreDot();
            }
            case CHART: {
                return this.getChartDot();
            }
            case POST: {
                return this.getPostDot();
            }
            case END: {
                return this.getEndDot();
            }
            case NEXT: {
                return this.getNextDot();
            }
        }
        return null;
    }

    private SnapShotOffset<SnapShot> getNextDot() {
        if (!this.nextSeries()) {
            return null;
        }
        return this.step();
    }

    private SnapShotOffset<SnapShot> getStartDot() {
        String state = this.serieState.toString();
        if (this.currentPagingList.isEmpty()) {
            return this.getNextDot();
        }
        long earliestOverallTimeNs = this.generator.getEarliestOverallTimeNs();
        if (this.repeatStartTwice) {
            this.repeatStartTwice = false;
        } else {
            this.setSerieState(SerieState.PRE);
        }
        return this.createZero(earliestOverallTimeNs, earliestOverallTimeNs, state);
    }

    private SnapShotOffset<SnapShot> getPreDot() {
        this.setSerieState(SerieState.PRE);
        String state = this.serieState.toString();
        BaseEntity firstSnapshot = (BaseEntity)this.currentPagingList.get(0);
        Long firstTimeNs = this.getSnapshotTime(firstSnapshot);
        long earliestOverallTimeNs = this.generator.getEarliestOverallTimeNs();
        long resolution = this.getSnapshotResolution(firstSnapshot);
        if (firstTimeNs > earliestOverallTimeNs + 2L * resolution) {
            this.setSerieState(SerieState.CHART);
            return this.createZero(firstTimeNs - resolution, firstTimeNs - resolution, state);
        }
        return this.getChartDot();
    }

    private SnapShotOffset<SnapShot> getChartDot() {
        this.setSerieState(SerieState.CHART);
        int currentPagingListSize = this.currentPagingList.size();
        this.nextIndex += SnapshotCounter.divider();
        do {
            if (this.index >= currentPagingListSize - 1) {
                return this.getPostDot();
            }
            if (this.currentPagingList == null) {
                return null;
            }
            ++this.index;
        } while ((double)this.index < this.nextIndex);
        BaseEntity snapshot = (BaseEntity)this.currentPagingList.get(this.index);
        long snapshotTime = this.getSnapshotTime(snapshot);
        long duration = this.getSnapshotDuration(snapshot);
        long halfDuration = duration / 2L;
        return new SnapShotOffset<BaseEntity>(snapshot, this.generator.getEarliestOverallTimeNs(), snapshotTime + halfDuration, snapshotTime, false, this.serieState.toString());
    }

    private long getHalfResolution(SnapShot snapshot) {
        long resolution = this.getSnapshotResolution(snapshot);
        long halfResolution = resolution / 2L;
        return halfResolution;
    }

    private SnapShotOffset<SnapShot> getPostDot() {
        this.setSerieState(SerieState.POST);
        String state = this.serieState.toString();
        int currentPagingListSize = this.currentPagingList.size();
        BaseEntity lastSnapshot = (BaseEntity)this.currentPagingList.get(currentPagingListSize - 1);
        long lastTimeStamp = this.getSnapshotTime(lastSnapshot);
        long resolution = this.getSnapshotResolution(lastSnapshot);
        long halfResolution = this.getHalfResolution(lastSnapshot);
        long postTimeStamp = lastTimeStamp + resolution;
        long lastOverallTimeNs = this.generator.getLastOverallTimeNs();
        if (postTimeStamp < lastOverallTimeNs) {
            this.setSerieState(SerieState.END);
        } else {
            this.setSerieState(SerieState.NEXT);
        }
        this.currentPagingList.clearBuffers();
        return this.createZero(postTimeStamp + halfResolution, postTimeStamp, state);
    }

    private SnapShotOffset<SnapShot> getEndDot() {
        this.setSerieState(SerieState.END);
        String state = this.serieState.toString();
        long lastOverallTimeNs = this.generator.getLastOverallTimeNs();
        int currentPagingListSize = this.currentPagingList.size();
        BaseEntity lastSnapshot = (BaseEntity)this.currentPagingList.get(currentPagingListSize - 1);
        long lastSnapDuration = this.getSnapshotDuration(lastSnapshot);
        long halfDuration = this.getHalfResolution(lastSnapshot);
        this.setSerieState(SerieState.NEXT);
        long chartPos = lastOverallTimeNs + lastSnapDuration;
        return this.createZero(chartPos + halfDuration, chartPos, state);
    }

    private boolean nextSeries() {
        if (this.currentPagingList != null) {
            this.currentPagingList.clearBuffers();
        }
        while (!this.pagingLists.isEmpty()) {
            this.currentPagingList = this.pagingLists.poll();
            if (this.currentPagingList.isEmpty()) continue;
            this.index = -1;
            this.setSerieState(SerieState.START);
            return true;
        }
        this.currentPagingList = null;
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    protected SnapShotOffset<SnapShot> getCurrentSnapshot() {
        return this.currentSnapshot;
    }

    protected abstract long getSnapshotResolution(SnapShot var1);

    protected abstract long getSnapshotDuration(SnapShot var1);

    protected abstract long getSnapshotTime(SnapShot var1);

    protected abstract boolean sameTime(SnapShot var1, long var2);

    protected SnapShotOffset<SnapShot> createZero(long timestampForChart, long timestampForTooltip, String serieState) {
        return new SnapShotOffset<Object>(null, this.generator.getEarliestOverallTimeNs(), timestampForChart, timestampForTooltip, true, serieState);
    }

    public String getSeries() {
        return this.currentPagingList.getSeries();
    }

    public DataRateUnit getDataRateUnit() {
        return this.generator.getDataRateUnit();
    }

    private static enum SerieState {
        START,
        PRE,
        CHART,
        POST,
        END,
        NEXT;

    }
}

