/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.datasource;

import com.excentis.products.byteblower.report.generator.jasper.datasource.PagingQueryDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.SnapShotOffset;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeSubReports;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.WiFiSample;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class RssiDataSource
extends PagingQueryDataSource<WiFiSample> {
    private String networkInterface;
    private String deviceName;
    private TestDataPersistenceController pc;
    private long ctr = 0L;

    public RssiDataSource(EntityManager entityManager, GenerateResultsOverTimeSubReports<?> generator, String deviceName, String networkInterface, TypedQuery<WiFiSample> query) {
        super(entityManager, generator, "RSSI", query);
        this.networkInterface = networkInterface;
        this.deviceName = deviceName;
    }

    public Object getFieldValue(JRField fillField) throws JRException {
        SnapShotOffset current = this.getCurrentSnapshot();
        WiFiSample sample = (WiFiSample)current.getSnapshot();
        String fieldName = fillField.getName();
        if ("device_name".equals(fieldName)) {
            return String.valueOf(this.deviceName) + ": " + this.networkInterface;
        }
        if ("results_over_time_rssi".equals(fieldName)) {
            if (sample != null) {
                return ((WiFiSample)current.getSnapshot()).getRssi();
            }
            return null;
        }
        if ("results_over_time_bssid".equals(fieldName)) {
            if (sample != null) {
                return ((WiFiSample)current.getSnapshot()).getBssid();
            }
            return null;
        }
        if ("results_over_time_ssid".equals(fieldName)) {
            if (sample != null) {
                return ((WiFiSample)current.getSnapshot()).getSsid();
            }
            return null;
        }
        if ("results_over_time_net_if".equals(fieldName)) {
            if (sample != null) {
                return ((WiFiSample)current.getSnapshot()).getNetinterface();
            }
            return null;
        }
        if ("results_over_time_port_name".equals(fieldName)) {
            if (sample != null) {
                return ((WiFiSample)current.getSnapshot()).getPortname();
            }
            return null;
        }
        if ("results_over_time_time".equals(fieldName)) {
            return current.getTimestampForChartMs(false);
        }
        System.err.format("Unknown field %s %n", fieldName);
        return "Unknown";
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    @Override
    public Class<?> getJRDataSourceClass() {
        return this.getClass();
    }

    @Override
    protected long getSnapshotResolution(WiFiSample snapshot) {
        return 1000000000L;
    }

    @Override
    protected long getSnapshotDuration(WiFiSample snapshot) {
        return 1000000000L;
    }

    @Override
    protected long getSnapshotTime(WiFiSample snapshot) {
        return snapshot.getTimestamp();
    }

    @Override
    protected boolean sameTime(WiFiSample snapshot, long proposedNs) {
        return snapshot.getTimestamp() == proposedNs;
    }
}

