/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.datasource;

import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.utils.UnitReader;
import java.util.Date;
import java.util.TimeZone;

public class SnapShotOffset<SnapShot extends BaseEntity> {
    SnapShot snapshot;
    long timestampForChartNs;
    long timestampForTooltipNs;
    String serieState;

    public SnapShotOffset(SnapShot snapshot, long earliestOverallTime, long timestampForChart, long timestampForTooltip, boolean putZero, String serieState) {
        this.snapshot = snapshot;
        this.serieState = serieState;
        if (timestampForChart < earliestOverallTime) {
            System.out.println("NEGATIVE CHART RELATIVE TIMESTAMP - SHOULD NEVER HAPPEN !");
        }
        timestampForChart -= earliestOverallTime;
        if (timestampForTooltip < earliestOverallTime) {
            System.out.println("NEGATIVE TOOLTIP RELATIVE TIMESTAMP - SHOULD NEVER HAPPEN !");
        }
        this.timestampForChartNs = timestampForChart;
        this.timestampForTooltipNs = timestampForTooltip -= earliestOverallTime;
    }

    public String getSerieState() {
        return this.serieState;
    }

    public long getTimestampForTooltipNs() {
        return this.timestampForTooltipNs;
    }

    public SnapShot getSnapshot() {
        return this.snapshot;
    }

    public long getTimestampForChartNs() {
        return this.timestampForChartNs;
    }

    public void setTimestampForChartNs(long timestamp) {
        this.timestampForChartNs = timestamp;
    }

    public void setTimestampForTooltipNs(long timestamp) {
        this.timestampForTooltipNs = timestamp;
    }

    public Long getTimestampForChartMs(boolean timeZoneCorrection) {
        long timestampNs = this.getTimestampForChartNs();
        long ms = Math.round(UnitReader.convert((Long)timestampNs, (UnitReader.UnitPrefix)UnitReader.UnitPrefix.NANO, (UnitReader.UnitPrefix)UnitReader.UnitPrefix.MILLI));
        if (timeZoneCorrection) {
            int offset = TimeZone.getDefault().getRawOffset();
            return ms - (long)offset;
        }
        return ms;
    }

    public Date getTimestampForChart(boolean timeZoneCorrection) {
        Long ms = this.getTimestampForChartMs(timeZoneCorrection);
        return new Date(ms);
    }
}

