/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.datasource;

import com.excentis.products.byteblower.report.generator.jasper.datasource.ByteBlowerReportDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.PagingQueryDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.SnapShotOffset;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeSubReports;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.TcpSessionReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.TcpSessionSnapshotReader;
import com.excentis.products.byteblower.results.testdata.data.utils.UnitReader;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.fill.JRFillField;

public class TcpReceiveWindowRotChartDataSource
extends PagingQueryDataSource<TcpSessionSnapshot> {
    private String flowName;

    public TcpReceiveWindowRotChartDataSource(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, String portName, TypedQuery<TcpSessionSnapshot> query) {
        super(entityManager, generator, portName, query);
        this.generator = generator;
        this.flowName = flowName;
    }

    public static ByteBlowerReportDataSource receiveWindow(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, String portName, TcpSessionReader tcpSessionReader) {
        TypedQuery query = tcpSessionReader.getSnapshotsQuery(entityManager);
        return new TcpReceiveWindowRotChartDataSource(entityManager, generator, flowName, portName, (TypedQuery<TcpSessionSnapshot>)query);
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        Object fieldValue = null;
        SnapShotOffset offset = this.getCurrentSnapshot();
        TcpSessionSnapshotReader reader = EntityReaderFactory.create((TcpSessionSnapshot)((TcpSessionSnapshot)offset.getSnapshot()));
        JRFillField fillField = (JRFillField)jrField;
        String fieldName = fillField.getName();
        if (fieldName.equals("results_over_time_series_1")) {
            fieldValue = this.getSeries();
        } else if (fieldName.equals("results_over_time_time")) {
            fieldValue = offset.getTimestampForChart(true);
        } else if (fieldName.equals("results_over_time_chart_name")) {
            fieldValue = this.flowName;
        } else if (fieldName.equals("data_unit")) {
            fieldValue = this.generator.getDataRateUnit().toString();
        } else if (fieldName.equals("data_type")) {
            fieldValue = "Bitrate";
        } else if (fieldName.equals("results_over_time_series_2")) {
            fieldValue = "RTT";
        } else if (fieldName.equals("data_type_axis_2")) {
            fieldValue = "Round Trip Time";
        } else if (fieldName.equals("data_unit_axis_2")) {
            fieldValue = this.generator.getLatencyUnit().toString();
        } else if (fieldName.equals("results_over_time_axis_2")) {
            Long val = reader.getRoundTripTime();
            fieldValue = UnitReader.convert((Double)val.doubleValue(), (UnitReader.UnitPrefix)UnitReader.UnitPrefix.NANO, (UnitReader.UnitPrefix)this.generator.getLatencyUnit().getUnitPrefix());
        } else if (fieldName.equals("results_over_time_series_3")) {
            fieldValue = "Transmit window";
        } else if (fieldName.equals("data_type_axis_3")) {
            fieldValue = "Window";
        } else if (fieldName.equals("data_unit_axis_3")) {
            fieldValue = "KBytes";
        } else if (fieldName.equals("results_over_time_axis_3")) {
            fieldValue = Math.min(reader.getReceiveWindowInKB(), reader.getCongestionWindowInKB());
        }
        return fieldValue;
    }

    @Override
    protected boolean sameTime(TcpSessionSnapshot snapshot, long timestamp) {
        return snapshot.getSnapshotTime() != timestamp;
    }

    @Override
    protected long getSnapshotDuration(TcpSessionSnapshot snapshot) {
        return snapshot.getSnapshotDuration();
    }

    @Override
    protected long getSnapshotTime(TcpSessionSnapshot snapshot) {
        return snapshot.getSnapshotTime();
    }

    @Override
    protected long getSnapshotResolution(TcpSessionSnapshot snapshot) {
        return snapshot.getSnapshotDuration();
    }
}

