/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.datasource;

import com.excentis.products.byteblower.report.generator.jasper.datasource.ByteBlowerReportDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.PagingQueryDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.SnapShotOffset;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeSubReports;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.TcpSessionReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.TcpSessionSnapshotReader;
import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.fill.JRFillField;

public class TcpThroughputRotChartDataSource
extends PagingQueryDataSource<TcpSessionSnapshot> {
    private final String flowName;
    private final ThroughputValue picker;

    private TcpThroughputRotChartDataSource(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, String portName, TypedQuery<TcpSessionSnapshot> query, ThroughputValue picker) {
        super(entityManager, generator, portName, query);
        this.flowName = flowName;
        this.picker = picker;
    }

    public static TcpThroughputRotChartDataSource txDataSource(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, String portName, TypedQuery<TcpSessionSnapshot> query) {
        return new TcpThroughputRotChartDataSource(entityManager, generator, flowName, portName, query, new TxThroughput());
    }

    public static ByteBlowerReportDataSource txThroughput(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, String portName, TcpSessionReader tcpSessionReader) {
        TypedQuery query = tcpSessionReader.getSnapshotsQuery(entityManager);
        return TcpThroughputRotChartDataSource.txDataSource(entityManager, generator, flowName, portName, (TypedQuery<TcpSessionSnapshot>)query);
    }

    public static ByteBlowerReportDataSource rxDataSource(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, String portName, TcpSessionReader tcpSessionReader) {
        TypedQuery query = tcpSessionReader.getSnapshotsQuery(entityManager);
        return TcpThroughputRotChartDataSource.rxDataSource(entityManager, generator, flowName, portName, (TypedQuery<TcpSessionSnapshot>)query);
    }

    public static TcpThroughputRotChartDataSource rxDataSource(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, String portName, TypedQuery<TcpSessionSnapshot> query) {
        return new TcpThroughputRotChartDataSource(entityManager, generator, flowName, portName, query, new RxThroughput());
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        Object fieldValue = null;
        SnapShotOffset offset = this.getCurrentSnapshot();
        TcpSessionSnapshotReader reader = EntityReaderFactory.create((TcpSessionSnapshot)((TcpSessionSnapshot)offset.getSnapshot()));
        JRFillField fillField = (JRFillField)jrField;
        String fieldName = fillField.getName();
        if ("results_over_time_series_1".equals(fieldName)) {
            fieldValue = this.getSeries();
        } else if ("results_over_time_time".equals(fieldName)) {
            fieldValue = offset.getTimestampForChart(true);
        } else if ("results_over_time_throughput".equals(fieldName)) {
            Double val = this.picker.throughput(reader, this.generator.getDataRateUnit());
            fieldValue = val;
        } else if ("results_over_time_chart_name".equals(fieldName)) {
            fieldValue = this.flowName;
        } else if ("data_unit".equals(fieldName)) {
            fieldValue = this.generator.getDataRateUnit().toString();
        } else if ("data_type".equals(fieldName)) {
            fieldValue = "Bitrate";
        } else if ("results_over_time_series_2".equals(fieldName)) {
            fieldValue = "RTT @TCP";
        } else if ("results_over_time_series_3".equals(fieldName)) {
            fieldValue = "Invalid Receive Window";
        } else if ("data_type_axis_3".equals(fieldName)) {
            fieldValue = "Window";
        } else if ("data_unit_axis_3".equals(fieldName)) {
            fieldValue = "KBytes";
        } else if ("results_over_time_axis_3".equals(fieldName)) {
            fieldValue = 0.0;
        }
        return fieldValue;
    }

    @Override
    protected boolean sameTime(TcpSessionSnapshot snapshot, long timestamp) {
        return snapshot.getSnapshotTime() != timestamp;
    }

    @Override
    protected long getSnapshotDuration(TcpSessionSnapshot snapshot) {
        return snapshot.getSnapshotDuration();
    }

    @Override
    protected long getSnapshotTime(TcpSessionSnapshot snapshot) {
        return snapshot.getSnapshotTime();
    }

    @Override
    protected long getSnapshotResolution(TcpSessionSnapshot snapshot) {
        return snapshot.getSnapshotDuration();
    }

    private static class RxThroughput
    implements ThroughputValue {
        private RxThroughput() {
        }

        @Override
        public Double throughput(TcpSessionSnapshotReader reader, DataRateUnit dataRateUnit) {
            return reader.getRxThroughput(dataRateUnit);
        }
    }

    private static interface ThroughputValue {
        public Double throughput(TcpSessionSnapshotReader var1, DataRateUnit var2);
    }

    private static class TxThroughput
    implements ThroughputValue {
        private TxThroughput() {
        }

        @Override
        public Double throughput(TcpSessionSnapshotReader reader, DataRateUnit dataRateUnit) {
            return reader.getTxThroughput(dataRateUnit);
        }
    }
}

