/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.datasource;

import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import com.excentis.products.byteblower.results.testdata.data.utils.ThroughputReader;
import com.excentis.products.byteblower.results.testdata.data.utils.UnitReader;
import jakarta.persistence.Entity;
import java.util.TimeZone;

@Entity
public class ThroughputSnapshot {
    long rxThroughput;
    long timestamp;

    public ThroughputSnapshot() {
        this.rxThroughput = 0L;
        this.timestamp = 0L;
    }

    public ThroughputSnapshot(long rxThroughput, long timestamp) {
        this.rxThroughput = rxThroughput;
        this.timestamp = timestamp;
    }

    double getConvertedThroughPut(DataRateUnit dataRateUnit) {
        return ThroughputReader.convertThroughput((Double)((double)this.rxThroughput + 0.0), (DataRateUnit)DataRateUnit.BYTE_PER_SECOND, (DataRateUnit)dataRateUnit);
    }

    public long getCorrectedSnapshotTimeMs() {
        return this.getSnapshotTimeMs() - (long)TimeZone.getDefault().getRawOffset();
    }

    public long getSnapshotTimeMs() {
        long ms = Math.round(UnitReader.convert((Long)this.timestamp, (UnitReader.UnitPrefix)UnitReader.UnitPrefix.NANO, (UnitReader.UnitPrefix)UnitReader.UnitPrefix.MILLI));
        return ms;
    }
}

