/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.datasource.highcharts;

import com.excentis.products.byteblower.report.generator.jasper.datasource.PagingQueryDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.SnapShotOffset;
import com.excentis.products.byteblower.report.generator.jasper.datasource.highcharts.DataSourceHelpers;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeSubReports;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatencySnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbLatencySnapshotReader;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.fill.JRFillField;

public class FbLatencyRotHighchartsDataSource
extends PagingQueryDataSource<FbLatencySnapshot> {
    private final String flowName;
    private final String destinationName;
    private final String sourceName;

    public FbLatencyRotHighchartsDataSource(EntityManager entityManager, GenerateResultsOverTimeSubReports<?> generator, String flowName, String sourceName, String destinationName, TypedQuery<FbLatencySnapshot> query) {
        super(entityManager, generator, flowName, query);
        this.flowName = flowName;
        this.destinationName = destinationName;
        this.sourceName = sourceName;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        SnapShotOffset offset = this.getCurrentSnapshot();
        FbLatencySnapshotReader reader = EntityReaderFactory.create((FbLatencySnapshot)((FbLatencySnapshot)offset.getSnapshot()));
        JRFillField fillField = (JRFillField)jrField;
        Object fieldValue = null;
        String fieldName = fillField.getName();
        if (fieldName.equals("results_over_time_series")) {
            fieldValue = this.getSeries();
        } else if (fieldName.equals("results_over_time_time")) {
            fieldValue = offset.getTimestampForChart(false);
        } else if (fieldName.equals("results_over_time_average")) {
            fieldValue = reader.getLatencyAverage(this.generator.getLatencyUnit());
        } else if (fieldName.equals("results_over_time_minimum")) {
            fieldValue = reader.getLatencyMinimum(this.generator.getLatencyUnit());
        } else if (fieldName.equals("results_over_time_maximum")) {
            fieldValue = reader.getLatencyMaximum(this.generator.getLatencyUnit());
        } else if (fieldName.equals("results_over_time_avg_plus_jitter")) {
            fieldValue = reader.getLatencyAverage(this.generator.getLatencyUnit()) + reader.getJitter(this.generator.getLatencyUnit());
        } else if (fieldName.equals("results_over_time_avg_minus_jitter")) {
            fieldValue = reader.getLatencyAverage(this.generator.getLatencyUnit()) - reader.getJitter(this.generator.getLatencyUnit());
        } else if (fieldName.equals("results_over_time_chart_name")) {
            fieldValue = DataSourceHelpers.chartTitle(this.flowName, this.sourceName, this.destinationName);
        } else if (fieldName.equals("results_over_time_jitter")) {
            fieldValue = reader.getJitter(this.generator.getLatencyUnit());
        } else if (fieldName.equals("results_over_time_time_s")) {
            Date snapshotTime = offset.getTimestampForChart(false);
            fieldValue = new SimpleDateFormat("HH'h 'mm'm 'ss's '").format(snapshotTime);
        } else if ("results_over_time_series_type".equals(fieldName)) {
            return "L";
        }
        return fieldValue;
    }

    @Override
    protected boolean sameTime(FbLatencySnapshot snapshot, long timestamp) {
        return snapshot.getSnapshotTime() != timestamp;
    }

    @Override
    protected long getSnapshotDuration(FbLatencySnapshot snapshot) {
        return snapshot.getSnapshotDuration();
    }

    @Override
    protected long getSnapshotTime(FbLatencySnapshot snapshot) {
        return snapshot.getSnapshotTime();
    }

    @Override
    protected long getSnapshotResolution(FbLatencySnapshot snapshot) {
        return snapshot.getLatency().getSnapshotResolution();
    }
}

