/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.datasource.highcharts;

import com.excentis.products.byteblower.report.generator.jasper.datasource.PagingQueryDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.SnapShotOffset;
import com.excentis.products.byteblower.report.generator.jasper.datasource.highcharts.DataSourceHelpers;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeSubReports;
import com.excentis.products.byteblower.results.testdata.data.entities.FbOutOfSequenceSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbOutOfSequenceSnapshotReader;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.fill.JRFillField;

public class FbOosRotHighchartsDataSource
extends PagingQueryDataSource<FbOutOfSequenceSnapshot> {
    private final String flowName;
    private final String sourceName;
    private final String destinationName;

    public FbOosRotHighchartsDataSource(EntityManager entityManager, GenerateResultsOverTimeSubReports<?> generator, String flowName, String sourceName, String destinationName, TypedQuery<FbOutOfSequenceSnapshot> query) {
        super(entityManager, generator, flowName, query);
        this.flowName = flowName;
        this.destinationName = destinationName;
        this.sourceName = sourceName;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        SnapShotOffset offset = this.getCurrentSnapshot();
        FbOutOfSequenceSnapshotReader reader = EntityReaderFactory.create((FbOutOfSequenceSnapshot)((FbOutOfSequenceSnapshot)offset.getSnapshot()));
        JRFillField fillField = (JRFillField)jrField;
        String fieldName = fillField.getName();
        Object fieldValue = null;
        if (fieldName.equals("results_over_time_series")) {
            return this.getSeries();
        }
        if (fieldName.equals("results_over_time_chart_name")) {
            fieldValue = DataSourceHelpers.chartTitle(this.flowName, this.sourceName, this.destinationName);
        } else if ("results_over_time_time".equals(fieldName)) {
            fieldValue = offset.getTimestampForChart(false);
        } else {
            if ("results_over_time_outofsequence".equals(fieldName)) {
                Double val = reader.getOutOfSequenceFrameRate();
                return val;
            }
            if ("results_over_time_tooltip_text".equals(fieldName)) {
                String time = HighResolutionCalendarParser.getRelativeTime((long)offset.getTimestampForChartNs());
                double val = reader.getOutOfSequenceFrameRate();
                fieldValue = "Out Of Sequence <br>" + time + "<br>" + val + " fps ";
            }
        }
        return fieldValue;
    }

    @Override
    protected boolean sameTime(FbOutOfSequenceSnapshot snapshot, long timestamp) {
        return snapshot.getSnapshotTime() != timestamp;
    }

    @Override
    protected long getSnapshotDuration(FbOutOfSequenceSnapshot snapshot) {
        return snapshot.getSnapshotDuration();
    }

    @Override
    protected long getSnapshotTime(FbOutOfSequenceSnapshot snapshot) {
        return snapshot.getSnapshotTime();
    }

    @Override
    protected long getSnapshotResolution(FbOutOfSequenceSnapshot snapshot) {
        return snapshot.getOutOfSequence().getSnapshotResolution();
    }
}

