/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.datasource.highcharts;

import com.excentis.products.byteblower.report.generator.jasper.datasource.PagingQueryDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.SnapShotOffset;
import com.excentis.products.byteblower.report.generator.jasper.datasource.highcharts.DataSourceHelpers;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeSubReports;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTriggerSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbTriggerSnapshotReader;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.fill.JRFillField;

public class FbThroughputRotHighchartsDataSource
extends PagingQueryDataSource<FbTriggerSnapshot> {
    private String flowName;
    private String destinationName;
    private String sourceName;

    public FbThroughputRotHighchartsDataSource(EntityManager entityManager, GenerateResultsOverTimeSubReports<?> generator, String flowName, String sourceName, String destinationName, TypedQuery<FbTriggerSnapshot> query) {
        super(entityManager, generator, flowName, query);
        this.flowName = flowName;
        this.destinationName = destinationName;
        this.sourceName = sourceName;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        SnapShotOffset offset = this.getCurrentSnapshot();
        FbTriggerSnapshotReader reader = EntityReaderFactory.create((FbTriggerSnapshot)((FbTriggerSnapshot)offset.getSnapshot()));
        JRFillField fillField = (JRFillField)jrField;
        String fieldName = fillField.getName();
        Object fieldValue = null;
        if (fieldName.equals("results_over_time_series")) {
            fieldValue = this.getSeries();
        } else if (fieldName.equals("results_over_time_chart_name")) {
            fieldValue = DataSourceHelpers.chartTitle(this.flowName, this.sourceName, this.destinationName);
        } else if ("results_over_time_time".equals(fieldName)) {
            fieldValue = offset.getTimestampForChart(false);
        } else if ("results_over_time_throughput".equals(fieldName) || "results_over_time_value".equals(fieldName)) {
            fieldValue = reader.getThroughput(this.generator.getEthernetThroughputType(), this.generator.getDataRateUnit());
        } else if ("results_over_time_tooltip_text".equals(fieldName)) {
            String time = HighResolutionCalendarParser.getRelativeTime((long)offset.getTimestampForChartNs());
            double val = reader.getThroughput(this.generator.getEthernetThroughputType(), this.generator.getDataRateUnit());
            String throughput = String.format("%.2f", val);
            fieldValue = "Throughput <br><b>" + throughput + " " + this.generator.getDataRateUnit() + "</b><br>@ " + time;
        }
        return fieldValue;
    }

    @Override
    protected boolean sameTime(FbTriggerSnapshot snapshot, long timestamp) {
        return snapshot.getSnapshotTime() != timestamp;
    }

    @Override
    protected long getSnapshotDuration(FbTriggerSnapshot snapshot) {
        return snapshot.getSnapshotDuration();
    }

    @Override
    protected long getSnapshotTime(FbTriggerSnapshot snapshot) {
        return snapshot.getSnapshotTime();
    }

    @Override
    protected long getSnapshotResolution(FbTriggerSnapshot snapshot) {
        return snapshot.getTrigger().getSnapshotResolution();
    }
}

