/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.datasource.highcharts;

import com.excentis.products.byteblower.report.generator.jasper.datasource.ByteBlowerReportDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.PagingQueryDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.SnapShotOffset;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeSubReports;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.TcpSessionReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.TcpSessionSnapshotReader;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.fill.JRFillField;

public class TcpRetransmissionWindowRotHighchartDataSource
extends PagingQueryDataSource<TcpSessionSnapshot> {
    private String flowName;

    public TcpRetransmissionWindowRotHighchartDataSource(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, String portName, TypedQuery<TcpSessionSnapshot> query) {
        super(entityManager, generator, portName, query);
        this.flowName = flowName;
    }

    public static ByteBlowerReportDataSource retransmissions(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, String portName, TcpSessionReader tcpSessionReader) {
        TypedQuery query = tcpSessionReader.getSnapshotsQuery(entityManager);
        return new TcpRetransmissionWindowRotHighchartDataSource(entityManager, generator, flowName, portName, (TypedQuery<TcpSessionSnapshot>)query);
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        Object fieldValue = null;
        SnapShotOffset offset = this.getCurrentSnapshot();
        TcpSessionSnapshotReader reader = EntityReaderFactory.create((TcpSessionSnapshot)((TcpSessionSnapshot)offset.getSnapshot()));
        JRFillField fillField = (JRFillField)jrField;
        String fieldName = fillField.getName();
        if ("results_over_time_flow_name".equals(fieldName)) {
            fieldValue = this.flowName;
        } else if ("results_over_time_series_type".equals(fieldName)) {
            fieldValue = "Z";
        } else if (fieldName.equals("results_over_time_series_name")) {
            fieldValue = "Z";
        } else if (fieldName.equals("results_over_time_time")) {
            fieldValue = offset.getTimestampForChart(false);
        } else if ("results_over_time_value".equals(fieldName)) {
            fieldValue = reader.getRetransmissions();
        } else if ("results_over_time_tooltip_text".equals(fieldName)) {
            String time = HighResolutionCalendarParser.getRelativeTime((long)offset.getTimestampForChartNs());
            Double val = reader.getRetransmissions();
            fieldValue = "Retransmissions<br>@ " + time + "<br>" + val;
        }
        return fieldValue;
    }

    @Override
    protected boolean sameTime(TcpSessionSnapshot snapshot, long timestamp) {
        return snapshot.getSnapshotTime() != timestamp;
    }

    @Override
    protected long getSnapshotDuration(TcpSessionSnapshot snapshot) {
        return snapshot.getSnapshotDuration();
    }

    @Override
    protected long getSnapshotTime(TcpSessionSnapshot snapshot) {
        return snapshot.getSnapshotTime();
    }

    @Override
    protected long getSnapshotResolution(TcpSessionSnapshot snapshot) {
        return snapshot.getSnapshotDuration();
    }
}

