/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.datasource.highcharts;

import com.excentis.products.byteblower.report.generator.jasper.datasource.ByteBlowerReportDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.PagingQueryDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.SnapShotOffset;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeSubReports;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.TcpSessionReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.TcpSessionSnapshotReader;
import com.excentis.products.byteblower.results.testdata.data.utils.LatencyUnit;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.function.Function;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.fill.JRFillField;

public class TcpRoundTripTimeRotHighchartDataSource
extends PagingQueryDataSource<TcpSessionSnapshot> {
    private final String flowName;
    private final SelectedRoundTripTime selection;

    public TcpRoundTripTimeRotHighchartDataSource(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, TypedQuery<TcpSessionSnapshot> query, SelectedRoundTripTime type) {
        super(entityManager, generator, type.seriesName, query);
        this.flowName = flowName;
        this.selection = type;
    }

    public static ByteBlowerReportDataSource avgRoundTripTime(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, TcpSessionReader tcpSessionReader) {
        TypedQuery query = tcpSessionReader.getSnapshotsQuery(entityManager);
        return new TcpRoundTripTimeRotHighchartDataSource(entityManager, generator, flowName, (TypedQuery<TcpSessionSnapshot>)query, SelectedRoundTripTime.AVG);
    }

    public static ByteBlowerReportDataSource maxRoundTripTime(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, TcpSessionReader tcpSessionReader) {
        TypedQuery query = tcpSessionReader.getSnapshotsQuery(entityManager);
        return new TcpRoundTripTimeRotHighchartDataSource(entityManager, generator, flowName, (TypedQuery<TcpSessionSnapshot>)query, SelectedRoundTripTime.MAX);
    }

    public static ByteBlowerReportDataSource minRoundTripTime(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, TcpSessionReader tcpSessionReader) {
        TypedQuery query = tcpSessionReader.getSnapshotsQuery(entityManager);
        return new TcpRoundTripTimeRotHighchartDataSource(entityManager, generator, flowName, (TypedQuery<TcpSessionSnapshot>)query, SelectedRoundTripTime.MIN);
    }

    private Double getSelectedRoundtrip(TcpSessionSnapshotReader snapshot) {
        long rttNs = this.selection.getter.apply(snapshot);
        return LatencyUnit.convert((Long)rttNs, (LatencyUnit)LatencyUnit.NANOSECONDS, (LatencyUnit)this.generator.getLatencyUnit());
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        Object fieldValue = null;
        SnapShotOffset offset = this.getCurrentSnapshot();
        TcpSessionSnapshotReader reader = EntityReaderFactory.create((TcpSessionSnapshot)((TcpSessionSnapshot)offset.getSnapshot()));
        JRFillField fillField = (JRFillField)jrField;
        String fieldName = fillField.getName();
        if ("results_over_time_flow_name".equals(fieldName)) {
            fieldValue = this.flowName;
        } else if ("results_over_time_series_type".equals(fieldName)) {
            fieldValue = this.selection.seriesName;
        } else if (fieldName.equals("results_over_time_series_name")) {
            fieldValue = this.getSeries();
        } else if (fieldName.equals("results_over_time_time")) {
            fieldValue = offset.getTimestampForChart(false);
        } else if (fieldName.equals("results_over_time_value")) {
            fieldValue = this.getSelectedRoundtrip(reader);
        } else if ("results_over_time_tooltip_text".equals(fieldName)) {
            String time = HighResolutionCalendarParser.getRelativeTime((long)offset.getTimestampForChartNs());
            double val = this.getSelectedRoundtrip(reader);
            String rtt = String.format("%.2f", val);
            fieldValue = "Round Trip Time<br>@ " + time + "<br>" + rtt + " " + this.generator.getLatencyUnit();
        }
        return fieldValue;
    }

    @Override
    protected boolean sameTime(TcpSessionSnapshot snapshot, long timestamp) {
        return snapshot.getSnapshotTime() != timestamp;
    }

    @Override
    protected long getSnapshotDuration(TcpSessionSnapshot snapshot) {
        return snapshot.getSnapshotDuration();
    }

    @Override
    protected long getSnapshotTime(TcpSessionSnapshot snapshot) {
        return snapshot.getSnapshotTime();
    }

    @Override
    protected long getSnapshotResolution(TcpSessionSnapshot snapshot) {
        return snapshot.getSnapshotDuration();
    }

    private static enum SelectedRoundTripTime {
        MIN("R", snapshot -> snapshot.getMinRoundTripTime()),
        MAX("S", snapshot -> snapshot.getMaxRoundTripTime()),
        AVG("T", snapshot -> snapshot.getRoundTripTime());

        final String seriesName;
        final Function<TcpSessionSnapshotReader, Long> getter;

        private SelectedRoundTripTime(String seriesName, Function<TcpSessionSnapshotReader, Long> getter) {
            this.seriesName = seriesName;
            this.getter = getter;
        }
    }
}

