/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.datasource.highcharts;

import com.excentis.products.byteblower.report.generator.jasper.datasource.ByteBlowerReportDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.PagingQueryDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.SnapShotOffset;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeSubReports;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.TcpSessionReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.TcpSessionSnapshotReader;
import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.fill.JRFillField;

public class TcpThroughputRotHighchartDataSource
extends PagingQueryDataSource<TcpSessionSnapshot> {
    private final String flowName;
    private final ThroughputValue picker;

    private TcpThroughputRotHighchartDataSource(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, String portName, TypedQuery<TcpSessionSnapshot> query, ThroughputValue picker) {
        super(entityManager, generator, portName, query);
        this.flowName = flowName;
        this.picker = picker;
    }

    public static TcpThroughputRotHighchartDataSource txDataSource(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, String portName, TypedQuery<TcpSessionSnapshot> query) {
        return new TcpThroughputRotHighchartDataSource(entityManager, generator, flowName, portName, query, new TxThroughput());
    }

    public static ByteBlowerReportDataSource txThroughput(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, String portName, TcpSessionReader tcpSessionReader) {
        TypedQuery query = tcpSessionReader.getSnapshotsQuery(entityManager);
        return TcpThroughputRotHighchartDataSource.txDataSource(entityManager, generator, flowName, portName, (TypedQuery<TcpSessionSnapshot>)query);
    }

    public static ByteBlowerReportDataSource rxDataSource(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, String portName, TcpSessionReader tcpSessionReader) {
        TypedQuery query = tcpSessionReader.getSnapshotsQuery(entityManager);
        return TcpThroughputRotHighchartDataSource.rxDataSource(entityManager, generator, flowName, portName, (TypedQuery<TcpSessionSnapshot>)query);
    }

    public static TcpThroughputRotHighchartDataSource rxDataSource(EntityManager entityManager, GenerateResultsOverTimeSubReports<HttpFlowInstance> generator, String flowName, String portName, TypedQuery<TcpSessionSnapshot> query) {
        return new TcpThroughputRotHighchartDataSource(entityManager, generator, flowName, portName, query, new RxThroughput());
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        Object fieldValue = null;
        SnapShotOffset offset = this.getCurrentSnapshot();
        TcpSessionSnapshotReader reader = EntityReaderFactory.create((TcpSessionSnapshot)((TcpSessionSnapshot)offset.getSnapshot()));
        JRFillField fillField = (JRFillField)jrField;
        String fieldName = fillField.getName();
        if ("results_over_time_flow_name".equals(fieldName)) {
            fieldValue = this.flowName;
        } else if ("results_over_time_series_type".equals(fieldName)) {
            fieldValue = "V";
        } else if ("results_over_time_series_name".equals(fieldName)) {
            fieldValue = this.getSeries();
        } else if ("results_over_time_time".equals(fieldName)) {
            fieldValue = offset.getTimestampForChart(false);
        } else if ("results_over_time_value".equals(fieldName)) {
            Double val = this.picker.throughput(reader, this.getDataRateUnit());
            fieldValue = val;
        } else if ("results_over_time_tooltip_text".equals(fieldName)) {
            String time = HighResolutionCalendarParser.getRelativeTime((long)offset.getTimestampForChartNs());
            Double val = this.picker.throughput(reader, this.getDataRateUnit());
            fieldValue = "Throughput<br>@ " + time + "<br>" + val + " " + this.getDataRateUnit();
        }
        return fieldValue;
    }

    @Override
    protected boolean sameTime(TcpSessionSnapshot snapshot, long timestamp) {
        return snapshot.getSnapshotTime() != timestamp;
    }

    @Override
    protected long getSnapshotDuration(TcpSessionSnapshot snapshot) {
        return snapshot.getSnapshotDuration();
    }

    @Override
    protected long getSnapshotTime(TcpSessionSnapshot snapshot) {
        return snapshot.getSnapshotTime();
    }

    @Override
    protected long getSnapshotResolution(TcpSessionSnapshot snapshot) {
        return snapshot.getSnapshotDuration();
    }

    private static class RxThroughput
    implements ThroughputValue {
        private RxThroughput() {
        }

        @Override
        public Double throughput(TcpSessionSnapshotReader reader, DataRateUnit dataRateUnit) {
            return reader.getRxThroughput(dataRateUnit);
        }
    }

    private static interface ThroughputValue {
        public Double throughput(TcpSessionSnapshotReader var1, DataRateUnit var2);
    }

    private static class TxThroughput
    implements ThroughputValue {
        private TxThroughput() {
        }

        @Override
        public Double throughput(TcpSessionSnapshotReader reader, DataRateUnit dataRateUnit) {
            return reader.getTxThroughput(dataRateUnit);
        }
    }
}

