/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.scriptlets;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.JRScriptletException;

public class ConversionScriptlet
extends JRDefaultScriptlet {
    public String hexStringToMacAddress(String hexStr) {
        if (hexStr == null) {
            return "";
        }
        if (hexStr.contains(":")) {
            return hexStr.toUpperCase();
        }
        if (hexStr.length() != 12) {
            return "";
        }
        hexStr = hexStr.toUpperCase();
        return String.valueOf(hexStr.substring(0, 2)) + ":" + hexStr.substring(2, 4) + ":" + hexStr.substring(4, 6) + ":" + hexStr.substring(6, 8) + ":" + hexStr.substring(8, 10) + ":" + hexStr.substring(10, 12);
    }

    public String numberToIPv4Address(long number) {
        short A = (short)((number & 0xFFFFFFFFFF000000L) >> 24);
        short B = (short)((number & 0xFF0000L) >> 16);
        short C = (short)((number & 0xFF00L) >> 8);
        short D = (short)(number & 0xFFL);
        return String.valueOf(A) + "." + B + "." + C + "." + D;
    }

    public String numberToFullIPv6Address(long number_low, long number_high) {
        String A = String.format("%04X", (int)((number_high & 0xFFFF000000000000L) >> 48 & 0xFFFFL));
        String B = String.format("%04X", (int)((number_high & 0xFFFF00000000L) >> 32 & 0xFFFFL));
        String C = String.format("%04X", (int)((number_high & 0xFFFF0000L) >> 16 & 0xFFFFL));
        String D = String.format("%04X", (int)((number_high & 0xFFFFL) >> 0 & 0xFFFFL));
        String E = String.format("%04X", (int)((number_low & 0xFFFF000000000000L) >> 48 & 0xFFFFL));
        String F = String.format("%04X", (int)((number_low & 0xFFFF00000000L) >> 32 & 0xFFFFL));
        String G = String.format("%04X", (int)((number_low & 0xFFFF0000L) >> 16 & 0xFFFFL));
        String H = String.format("%04X", (int)((number_low & 0xFFFFL) >> 0 & 0xFFFFL));
        return String.valueOf(A) + ":" + B + ":" + C + ":" + D + ":" + E + ":" + F + ":" + G + ":" + H;
    }

    public String numberToIpv6Address(long number_low, long number_high) throws JRScriptletException {
        String full = this.numberToFullIPv6Address(number_low, number_high);
        String[] full_split = full.split(":");
        boolean shortUsed = false;
        boolean shortBusy = false;
        String address = "";
        String joiner = "";
        String[] stringArray = full_split;
        int n = full_split.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!shortUsed && part.equals("0000")) {
                if (!shortBusy) {
                    address = String.valueOf(address) + ":";
                    shortBusy = true;
                }
            } else {
                if (shortBusy) {
                    shortBusy = false;
                    shortUsed = true;
                }
                address = String.valueOf(address) + joiner + part.replaceFirst("^0+(?!$)", "");
            }
            joiner = ":";
            ++n2;
        }
        return address;
    }

    public String numberToServerVersion(long number) {
        short A = (short)(number / 1000000000L);
        short B = (short)((number -= (long)A * 1000000000L) / 1000000L);
        short C = (short)((number -= (long)B * 1000000L) / 1000L);
        short D = (short)((number -= (long)C * 1000L) / 1L);
        return String.valueOf(A) + "." + B + "." + C + "." + D;
    }

    public String deltaTimeToString(BigDecimal number, String precision) {
        String timestamp = "00:00:00,000";
        if (number == null || precision == null) {
            return timestamp;
        }
        precision = precision.toLowerCase();
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss,SSS");
        if (precision.equals("hour")) {
            formatter = new SimpleDateFormat("HH");
        } else if (precision.equals("minute")) {
            formatter = new SimpleDateFormat("HH:mm");
        } else if (precision.equals("second")) {
            formatter = new SimpleDateFormat("HH:mm:ss");
        }
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        long millis = (long)(number.doubleValue() / 1000.0);
        BigDecimal millisInMicros = new BigDecimal(millis * 1000L);
        long micros = number.subtract(millisInMicros).longValue();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTimeInMillis(millis);
        timestamp = formatter.format(calendar.getTime());
        if (precision.equals("microsecond")) {
            timestamp = String.valueOf(timestamp) + String.format("%03d", micros);
        }
        return timestamp;
    }

    public String dateTimeToString(BigDecimal number, String least_significant_precision, String most_significant_precision) throws JRScriptletException {
        String dateTimestamp = "1970-01-01 00:00:00,000";
        if (number == null || least_significant_precision == null || most_significant_precision == null) {
            return dateTimestamp;
        }
        least_significant_precision = least_significant_precision.toLowerCase();
        most_significant_precision = most_significant_precision.toLowerCase();
        String format = "";
        String joiner = "";
        if (least_significant_precision.equals("day")) {
            format = String.valueOf(format) + "yyyy-MM-dd ";
        }
        if ((least_significant_precision.equals("day") || least_significant_precision.equals("hour")) && !most_significant_precision.equals("day")) {
            format = String.valueOf(format) + "HH";
            joiner = ":";
        }
        if ((least_significant_precision.equals("day") || least_significant_precision.equals("hour") || least_significant_precision.equals("minute")) && !most_significant_precision.equals("day") && !most_significant_precision.equals("hour")) {
            format = String.valueOf(format) + joiner + "mm";
            joiner = ":";
        }
        if ((least_significant_precision.equals("day") || least_significant_precision.equals("hour") || least_significant_precision.equals("minute") || least_significant_precision.equals("second")) && !most_significant_precision.equals("day") && !most_significant_precision.equals("hour") && !most_significant_precision.equals("minute")) {
            format = String.valueOf(format) + joiner + "ss";
            joiner = ",";
        }
        if ((least_significant_precision.equals("day") || least_significant_precision.equals("hour") || least_significant_precision.equals("minute") || least_significant_precision.equals("second") || least_significant_precision.equals("millisecond")) && !most_significant_precision.equals("day") && !most_significant_precision.equals("hour") && !most_significant_precision.equals("minute") && !most_significant_precision.equals("second")) {
            format = String.valueOf(format) + joiner + "SSS";
            joiner = "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        long millis = (long)(number.doubleValue() / 1000.0);
        BigDecimal millisInMicros = new BigDecimal(millis * 1000L);
        long micros = number.subtract(millisInMicros).longValue();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTimeInMillis(millis);
        dateTimestamp = formatter.format(calendar.getTime());
        if (most_significant_precision.equals("microsecond")) {
            dateTimestamp = String.valueOf(dateTimestamp) + String.format("%03d", micros);
        }
        return dateTimestamp;
    }

    public Date microSecondsToDateInMilliSeconds(BigDecimal number) {
        long millis = (long)(number.doubleValue() / 1000.0);
        Calendar calendarLocal = Calendar.getInstance();
        calendarLocal.setTimeInMillis(millis);
        int offset = TimeZone.getTimeZone("GMT").getOffset(millis) - TimeZone.getDefault().getOffset(millis);
        calendarLocal.add(14, offset);
        return calendarLocal.getTime();
    }

    public String getDateTimestampFormatString(String least_significant_precision, String most_significant_precision) {
        if (least_significant_precision == null || most_significant_precision == null) {
            return "yyyy-MM-dd HH:mm:ss,SSS";
        }
        least_significant_precision = least_significant_precision.toLowerCase();
        most_significant_precision = most_significant_precision.toLowerCase();
        String format = "";
        String joiner = "";
        if (least_significant_precision.equals("day")) {
            format = String.valueOf(format) + "yyyy-MM-dd ";
        }
        if ((least_significant_precision.equals("day") || least_significant_precision.equals("hour")) && !most_significant_precision.equals("day")) {
            format = String.valueOf(format) + "HH";
            joiner = ":";
        }
        if ((least_significant_precision.equals("day") || least_significant_precision.equals("hour") || least_significant_precision.equals("minute")) && !most_significant_precision.equals("day") && !most_significant_precision.equals("hour")) {
            format = String.valueOf(format) + joiner + "mm";
            joiner = ":";
        }
        if ((least_significant_precision.equals("day") || least_significant_precision.equals("hour") || least_significant_precision.equals("minute") || least_significant_precision.equals("second")) && !most_significant_precision.equals("day") && !most_significant_precision.equals("hour") && !most_significant_precision.equals("minute")) {
            format = String.valueOf(format) + joiner + "ss";
            joiner = ",";
        }
        if ((least_significant_precision.equals("day") || least_significant_precision.equals("hour") || least_significant_precision.equals("minute") || least_significant_precision.equals("second") || least_significant_precision.equals("millisecond")) && !most_significant_precision.equals("day") && !most_significant_precision.equals("hour") && !most_significant_precision.equals("minute") && !most_significant_precision.equals("second")) {
            format = String.valueOf(format) + joiner + "SSS";
            joiner = "";
        }
        return format;
    }
}

