/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports;

import com.excentis.products.byteblower.report.data.entities.widgets.ErrorInfoTableWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.jasper.GenerateReport;
import com.excentis.products.byteblower.report.generator.jasper.subreports.GenerateBeanCollectionSubReport;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.EventInfoTableBean;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.entities.Event;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstanceEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.PortEvent;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class GenerateErrorInfoTable
extends GenerateBeanCollectionSubReport {
    public static GenerateErrorInfoTable create(GenerateReport<GenerateReportListener> parentAction, ErrorInfoTableWidgetEntity widget, ReportGeneration reportGeneration) {
        return new GenerateErrorInfoTable(parentAction, widget, reportGeneration);
    }

    private GenerateErrorInfoTable(GenerateReport<GenerateReportListener> parentAction, ErrorInfoTableWidgetEntity widget, ReportGeneration reportGeneration) {
        super(parentAction, (ReportItemWidgetEntity)widget, reportGeneration, (GenerateReportListener)parentAction.getListener());
    }

    @Override
    protected void fillBeans() {
        EventManager manager = this.getErrorManager();
        List events = manager.getEntities();
        Collections.sort(events, new Comparator<Event>(){

            @Override
            public int compare(Event o1, Event o2) {
                int dateCompare = o1.getEventTime().compareTo(o2.getEventTime());
                if (dateCompare != 0) {
                    return dateCompare;
                }
                if (o1 instanceof FlowInstanceEvent && o2 instanceof FlowInstanceEvent) {
                    return ((FlowInstanceEvent)o1).getFlowInstance().getScenarioPosition().compareTo(((FlowInstanceEvent)o2).getFlowInstance().getScenarioPosition());
                }
                if (o1 instanceof PortEvent && o2 instanceof PortEvent) {
                    return ((PortEvent)o1).getPort().getId().compareTo(((PortEvent)o2).getPort().getId());
                }
                return 0;
            }
        });
        for (Event event : events) {
            if (event.getSeverity() != EventSeverity.TEST_ERROR) continue;
            EventInfoTableBean bean = new EventInfoTableBean(event);
            this.beans.add(bean);
        }
    }

    private EventManager getErrorManager() {
        return new EventManager(this.getPersistenceController());
    }
}

