/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports;

import com.excentis.products.byteblower.report.data.entities.widgets.FrameBlastingLatencyTableWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.FrameBlastingOosTableWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.FrameBlastingTableWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.report.generator.jasper.GenerateReport;
import com.excentis.products.byteblower.report.generator.jasper.subreports.GenerateBeanCollectionSubReport;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.FrameBlastingTableBean;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.FbFlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfig;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import java.util.List;
import java.util.Set;

public class GenerateFrameBlastingTable
extends GenerateBeanCollectionSubReport {
    private boolean hasVlansInvolved = false;

    public static GenerateFrameBlastingTable create(GenerateReport<GenerateReportListener> parentAction, ReportItemWidgetEntity widget, ReportGeneration reportGeneration) {
        return new GenerateFrameBlastingTable(parentAction, widget, reportGeneration);
    }

    private GenerateFrameBlastingTable(GenerateReport<GenerateReportListener> parentAction, ReportItemWidgetEntity widget, ReportGeneration reportGeneration) {
        super(parentAction, widget, reportGeneration, (GenerateReportListener)parentAction.getListener());
    }

    @Override
    protected void fillBeans() {
        FlowInstanceManager manager = this.getFlowInstanceManager();
        EventManager eventManager = this.getErrorManager();
        ReportPreferencesInterface pref = this.getReportPreferences();
        Scenario scenario = this.getScenario();
        List fbFlows = manager.getAllFrameBlasting(scenario);
        for (FbFlowInstance flowInstance : fbFlows) {
            FbFlowInstanceReader flowInstanceReader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
            if (!flowInstanceReader.isConfigured()) continue;
            FbFlowInstanceManager flowManager = new FbFlowInstanceManager(this.getPersistenceController());
            Set destinations = flowManager.getFbDestinationsAndEavesdroppers(flowInstance);
            for (FbDestination destination : destinations) {
                FrameBlastingTableBean bean = new FrameBlastingTableBean(flowInstance, destination, pref, eventManager.getAllFlowInstanceEvents((FlowInstance)flowInstance));
                if (bean.getFrame_blasting_rx_has_vlan() == Boolean.TRUE || bean.getFrame_blasting_tx_has_vlan() == Boolean.TRUE) {
                    this.hasVlansInvolved = true;
                }
                if (!this.needToAdd(bean)) continue;
                this.beans.add(bean);
            }
            if (!destinations.isEmpty()) continue;
            FbDestinationConfig destinationConfig = flowInstance.getDestinationConfig();
            FrameBlastingTableBean bean = new FrameBlastingTableBean(flowInstance, destinationConfig, pref);
            if (bean.getFrame_blasting_rx_has_vlan() == Boolean.TRUE || bean.getFrame_blasting_tx_has_vlan() == Boolean.TRUE) {
                this.hasVlansInvolved = true;
            }
            if (!this.needToAdd(bean)) continue;
            this.beans.add(bean);
        }
    }

    @Override
    protected void registerParameters() {
        super.registerParameters();
        this.addCascadeParameter("vlan", this.hasVlansInvolved, Boolean.class);
    }

    private boolean needToAdd(FrameBlastingTableBean bean) {
        if (this.widget instanceof FrameBlastingLatencyTableWidgetEntity) {
            return bean.hasLatency();
        }
        if (this.widget instanceof FrameBlastingOosTableWidgetEntity) {
            return bean.hasOos();
        }
        return this.widget instanceof FrameBlastingTableWidgetEntity;
    }

    private EventManager getErrorManager() {
        return new EventManager(this.getPersistenceController());
    }

    private FlowInstanceManager getFlowInstanceManager() {
        return new FlowInstanceManager(this.getPersistenceController());
    }
}

