/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports;

import com.excentis.products.byteblower.report.data.entities.widgets.IPv4NatPortTableWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.jasper.GenerateReport;
import com.excentis.products.byteblower.report.generator.jasper.subreports.GenerateBeanCollectionSubReport;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.IPv4NatPortTableBean;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.testdata.data.NatAddressMappingManager;
import com.excentis.products.byteblower.results.testdata.data.NatPortMappingManager;
import com.excentis.products.byteblower.results.testdata.data.PortManager;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4NatConfiguration;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4;
import com.excentis.products.byteblower.results.testdata.data.entities.NatAddressMapping;
import com.excentis.products.byteblower.results.testdata.data.entities.NatPortMapping;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import java.util.List;

public class GenerateIPv4NatPortTable
extends GenerateBeanCollectionSubReport {
    public static GenerateIPv4NatPortTable create(GenerateReport<GenerateReportListener> parentAction, IPv4NatPortTableWidgetEntity widget, ReportGeneration reportGeneration) {
        return new GenerateIPv4NatPortTable(parentAction, widget, reportGeneration);
    }

    private GenerateIPv4NatPortTable(GenerateReport<GenerateReportListener> parentAction, IPv4NatPortTableWidgetEntity widget, ReportGeneration reportGeneration) {
        super(parentAction, (ReportItemWidgetEntity)widget, reportGeneration, (GenerateReportListener)parentAction.getListener());
    }

    @Override
    protected void fillBeans() {
        PortManager portManager = this.getPortManager();
        List ports = portManager.getEntities();
        NatAddressMappingManager addressMapManager = this.getNatAddressMappingManager();
        NatPortMappingManager portMapManager = this.getNatPortMappingManager();
        Scenario scenario = this.getScenario();
        if (ports != null) {
            for (Port port : ports) {
                Layer3Ipv4 layer3Ipv4;
                Ipv4NatConfiguration natConfiguration;
                Layer3 layer3 = port.getLayer3();
                if (!(layer3 instanceof Layer3Ipv4) || (natConfiguration = (layer3Ipv4 = (Layer3Ipv4)layer3).getNatConfiguration()) == null) continue;
                List addressMappings = addressMapManager.find(scenario, port);
                for (NatAddressMapping addressMapping : addressMappings) {
                    List portMappings = portMapManager.findAll(addressMapping);
                    for (NatPortMapping portMapping : portMappings) {
                        IPv4NatPortTableBean bean = new IPv4NatPortTableBean(port, addressMapping, portMapping);
                        this.beans.add(bean);
                    }
                }
            }
        }
    }

    private PortManager getPortManager() {
        return new PortManager(this.getPersistenceController());
    }

    private NatAddressMappingManager getNatAddressMappingManager() {
        return new NatAddressMappingManager(this.getPersistenceController());
    }

    private NatPortMappingManager getNatPortMappingManager() {
        return new NatPortMappingManager(this.getPersistenceController());
    }
}

