/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports;

import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.jasper.GenerateReport;
import com.excentis.products.byteblower.report.generator.jasper.subreports.GenerateBeanCollectionSubReport;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.IPv4MobileAppTableBean;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.IPv4PortTableBean;
import com.excentis.products.byteblower.report.generator.jasper.subreports.entities.IPv4PortTableWidgetEntity;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import java.util.Collection;

public class GenerateIPv4PortTable
extends GenerateBeanCollectionSubReport {
    private final IPv4PortTableWidgetEntity baseWidget;

    public static GenerateIPv4PortTable create(GenerateReport<GenerateReportListener> parentAction, IPv4PortTableWidgetEntity widget, ReportGeneration reportGeneration) {
        return new GenerateIPv4PortTable(parentAction, widget, reportGeneration);
    }

    private GenerateIPv4PortTable(GenerateReport<GenerateReportListener> parentAction, IPv4PortTableWidgetEntity widget, ReportGeneration reportGeneration) {
        super(parentAction, widget, reportGeneration, (GenerateReportListener)parentAction.getListener());
        this.baseWidget = widget;
    }

    @Override
    protected void fillBeans() {
        Collection<Port> ports = this.baseWidget.getPorts();
        EventManager eventManager = this.getErrorManager();
        if (ports != null) {
            for (Port port : ports) {
                IPv4PortTableBean bean;
                if (!(port.getLayer3() instanceof Layer3Ipv4)) continue;
                if (port.getLayer2() == null) {
                    bean = new IPv4MobileAppTableBean(port, eventManager.getAllPortEvents(port), this.baseWidget.name());
                    this.beans.add(bean);
                    continue;
                }
                bean = new IPv4PortTableBean(port, eventManager.getAllPortEvents(port), this.baseWidget.name());
                this.beans.add(bean);
            }
        }
    }

    private EventManager getErrorManager() {
        return new EventManager(this.getPersistenceController());
    }
}

