/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports;

import com.excentis.products.byteblower.report.data.entities.widgets.LatencyResultsOverTimeTablesWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.jasper.GenerateReport;
import com.excentis.products.byteblower.report.generator.jasper.subreports.GenerateFbLatencyResultsOverTimeTables;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.ResultsOverTimeChartBean;
import com.excentis.products.byteblower.report.generator.jasper.subreports.entities.LatencyResultsOverTimeTableEntity;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeSubReports;
import com.excentis.products.byteblower.report.generator.jasper.subreports.parts.GenerateFbLatencyResultsOverTimeTable;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignSection;

public abstract class GenerateResultsOverTimeTables<FlowType extends FlowInstance>
extends GenerateResultsOverTimeSubReports<FlowType> {
    private static Map<TestDataReference, Long> firstOverallTimeNs = new HashMap<TestDataReference, Long>();
    private static Map<TestDataReference, Long> lastOverallTimeNs = new HashMap<TestDataReference, Long>();

    public static GenerateResultsOverTimeSubReports<FbFlowInstance> createLatencyTables(GenerateReport<GenerateReportListener> parentAction, LatencyResultsOverTimeTablesWidgetEntity widget, ReportGeneration reportGeneration) {
        return new GenerateFbLatencyResultsOverTimeTables(parentAction, (ReportItemWidgetEntity)widget, reportGeneration, FbFlowInstance.class);
    }

    public static GenerateFbLatencyResultsOverTimeTable createLatencyTable(GenerateReport<GenerateReportListener> parentReport, LatencyResultsOverTimeTableEntity widget, ReportGeneration reportGeneration) {
        return new GenerateFbLatencyResultsOverTimeTable(parentReport, widget, reportGeneration);
    }

    GenerateResultsOverTimeTables(GenerateReport<GenerateReportListener> parentAction, ReportItemWidgetEntity widget, ReportGeneration reportGeneration, Class<FlowType> flowType) {
        super(parentAction, widget, reportGeneration, flowType);
    }

    @Override
    protected boolean hasSubReports() {
        return true;
    }

    @Override
    public ReportItemWidgetEntity getWidget() {
        return this.widget;
    }

    @Override
    protected ReportItemWidgetEntity createSubReportEntity(ResultsOverTimeChartBean<?> bean) {
        return new LatencyResultsOverTimeTableEntity(bean);
    }

    @Override
    protected void generateSubReports() {
        Collection<?> beans = this.getBeans();
        int width = this.jasperDesign.getPageWidth();
        JRDesignSection designSection = (JRDesignSection)this.jasperDesign.getDetailSection();
        JRDesignBand designBand = new JRDesignBand();
        designSection.addBand((JRBand)designBand);
        Iterator<?> iterator = beans.iterator();
        if (iterator.hasNext()) {
            ResultsOverTimeChartBean bean = (ResultsOverTimeChartBean)iterator.next();
            ReportItemWidgetEntity entity = this.createSubReportEntity(bean);
            JRDesignExpression source = new JRDesignExpression("$F{chart_data}");
            boolean result = this.insertSubReport(designBand, entity, 0, width, 0, (JRExpression)source, true);
            if (!result) {
                while (designSection.getBands().length > 0) {
                    designSection.removeBand(0);
                }
                this.jasperDesign.setTitle((JRBand)new JRDesignBand());
            }
        }
    }

    @Override
    protected FlowInstanceManager getFlowInstanceManager() {
        return new FlowInstanceManager(this.getPersistenceController());
    }

    private static Long getEarliestOverallTimeNs(GenerateResultsOverTimeTables<?> generator) {
        TestDataReference testDataReference = generator.getTestDataReference();
        if (firstOverallTimeNs.containsKey(testDataReference)) {
            return firstOverallTimeNs.get(testDataReference);
        }
        EntityManager entityManager = generator.getEntityManager();
        Long min = Long.MAX_VALUE;
        min = GenerateResultsOverTimeTables.minimum(min, GenerateResultsOverTimeTables.getMinMaxSnapshotTime(entityManager, "FbTriggerSnapshot", false));
        min = GenerateResultsOverTimeTables.minimum(min, GenerateResultsOverTimeTables.getMinMaxSnapshotTime(entityManager, "FbLatencySnapshot", false));
        min = GenerateResultsOverTimeTables.minimum(min, GenerateResultsOverTimeTables.getMinMaxSnapshotTime(entityManager, "FbOutOfSequenceSnapshot", false));
        min = GenerateResultsOverTimeTables.minimum(min, GenerateResultsOverTimeTables.getMinMaxSnapshotTime(entityManager, "HttpSessionSnapshot", false));
        firstOverallTimeNs.put(testDataReference, min);
        return min;
    }

    private static Long minimum(Long min1, Long min2) {
        if (min1 == null && min2 == null) {
            return 0L;
        }
        if (min1 == null) {
            return min2;
        }
        if (min2 == null) {
            return min1;
        }
        return Math.min(min1, min2);
    }

    private static Long getLastOverallTimeNs(GenerateResultsOverTimeTables<?> generator) {
        TestDataReference testDataReference = generator.getTestDataReference();
        if (lastOverallTimeNs.containsKey(testDataReference)) {
            return lastOverallTimeNs.get(testDataReference);
        }
        EntityManager entityManager = generator.getEntityManager();
        Long max = 0L;
        max = GenerateResultsOverTimeTables.maximum(max, GenerateResultsOverTimeTables.getMinMaxSnapshotTime(entityManager, "FbTriggerSnapshot", true));
        max = GenerateResultsOverTimeTables.maximum(max, GenerateResultsOverTimeTables.getMinMaxSnapshotTime(entityManager, "FbLatencySnapshot", true));
        max = GenerateResultsOverTimeTables.maximum(max, GenerateResultsOverTimeTables.getMinMaxSnapshotTime(entityManager, "FbOutOfSequenceSnapshot", true));
        max = GenerateResultsOverTimeTables.maximum(max, GenerateResultsOverTimeTables.getMinMaxSnapshotTime(entityManager, "HttpSessionSnapshot", true));
        lastOverallTimeNs.put(testDataReference, max);
        return max;
    }

    private static Long maximum(Long max1, Long max2) {
        if (max1 == null && max2 == null) {
            return 0L;
        }
        if (max1 == null) {
            return max2;
        }
        if (max2 == null) {
            return max1;
        }
        return Math.max(max1, max2);
    }

    private static Long getMinMaxSnapshotTime(EntityManager entityManager, String table, boolean max) {
        return GenerateResultsOverTimeTables.getMinMax(entityManager, table, max, "snapshotTime");
    }

    private static Long getMinMax(EntityManager entityManager, String table, boolean max, String field) {
        String minMax = max ? "MAX" : "MIN";
        String queryString = "SELECT " + minMax + "(s." + field + ") FROM " + table + " s";
        TypedQuery query = entityManager.createQuery(queryString, Long.class);
        Long result = (Long)query.getSingleResult();
        return result;
    }

    @Override
    public Long getEarliestOverallTimeNs() {
        return GenerateResultsOverTimeTables.getEarliestOverallTimeNs(this);
    }

    @Override
    public Long getLastOverallTimeNs() {
        return GenerateResultsOverTimeTables.getLastOverallTimeNs(this);
    }
}

