/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports;

import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.TcpAggregateRxWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.jasper.GenerateReport;
import com.excentis.products.byteblower.report.generator.jasper.subreports.GenerateBeanCollectionSubReport;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.TcpAggregateThroughputTableBean;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.enums.HttpRequestMethod;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class GenerateTcpAggregateRxTable
extends GenerateBeanCollectionSubReport {
    public static GenerateTcpAggregateRxTable create(GenerateReport<GenerateReportListener> parentAction, TcpAggregateRxWidgetEntity widget, ReportGeneration reportGeneration) {
        return new GenerateTcpAggregateRxTable(parentAction, widget, reportGeneration);
    }

    private GenerateTcpAggregateRxTable(GenerateReport<GenerateReportListener> parentAction, TcpAggregateRxWidgetEntity widget, ReportGeneration reportGeneration) {
        super(parentAction, (ReportItemWidgetEntity)widget, reportGeneration, (GenerateReportListener)parentAction.getListener());
    }

    @Override
    protected void fillBeans() {
        HashMap<Port, RxTcpAggregation> rxAggregationMap = new HashMap<Port, RxTcpAggregation>();
        Scenario scenario = this.getScenario();
        List allTcps = this.getFlowInstanceManager().getAllTcp(scenario);
        for (HttpFlowInstance http : allTcps) {
            HttpSession rxSession;
            HttpFlowInstanceReader httpFlowInstanceReader = EntityReaderFactory.create((HttpFlowInstance)http);
            if (!httpFlowInstanceReader.isConfigured() || (rxSession = http.getRequestMethod().equals((Object)HttpRequestMethod.GET) ? http.getClientHttpSession() : http.getServerHttpSession()) == null) continue;
            Port rxPort = rxSession.getHttpApplication().getPort();
            RxTcpAggregation rxAggregation = (RxTcpAggregation)rxAggregationMap.get(rxPort);
            if (rxAggregation == null) {
                rxAggregation = new RxTcpAggregation(rxPort);
                rxAggregationMap.put(rxPort, rxAggregation);
            }
            rxAggregation.add(rxSession);
        }
        for (Port port : rxAggregationMap.keySet()) {
            RxTcpAggregation tcpAggregation = (RxTcpAggregation)rxAggregationMap.get(port);
            if (!tcpAggregation.valid()) continue;
            this.beans.add(tcpAggregation.createRxBean());
        }
    }

    private FlowInstanceManager getFlowInstanceManager() {
        return new FlowInstanceManager(this.getPersistenceController());
    }

    private final class RxTcpAggregation {
        private List<HttpSession> httpSessions = new ArrayList<HttpSession>();
        private Port port;
        private boolean hasSessions;

        public RxTcpAggregation(Port port) {
            this.port = port;
            this.hasSessions = false;
        }

        public void add(HttpSession httpSession) {
            if (httpSession != null && httpSession.getRxFirstByteTime() != null) {
                this.httpSessions.add(httpSession);
                this.hasSessions = true;
            }
        }

        public boolean valid() {
            return this.hasSessions;
        }

        protected TcpAggregateThroughputTableBean createRxBean() {
            Collections.sort(this.httpSessions, new Comparator<HttpSession>(){

                @Override
                public int compare(HttpSession lhs, HttpSession rhs) {
                    long lhsRxFirstByteTime = lhs.getRxFirstByteTime();
                    long rhsRxFirstByteTime = rhs.getRxFirstByteTime();
                    return Long.compare(lhsRxFirstByteTime, rhsRxFirstByteTime);
                }
            });
            Long smallestFirstByteTime = 0L;
            Long rxFirstByteTime = this.httpSessions.get(0).getRxFirstByteTime();
            if (rxFirstByteTime != null) {
                smallestFirstByteTime = rxFirstByteTime;
            }
            Long biggestLastByteTime = 0L;
            Long totalGapTime = 0L;
            Long totalRxBytes = 0L;
            for (HttpSession httpSession : this.httpSessions) {
                if (biggestLastByteTime != null && httpSession.getRxLastByteTime() != null && biggestLastByteTime == 0L) {
                    biggestLastByteTime = httpSession.getRxLastByteTime();
                } else {
                    if (httpSession.getRxFirstByteTime() != null && httpSession.getRxFirstByteTime() > biggestLastByteTime) {
                        totalGapTime = totalGapTime + (httpSession.getRxFirstByteTime() - biggestLastByteTime);
                    }
                    if (httpSession.getRxLastByteTime() != null && httpSession.getRxLastByteTime() > biggestLastByteTime) {
                        biggestLastByteTime = httpSession.getRxLastByteTime();
                    }
                }
                Long rxByteCount = httpSession.getRxByteCount();
                if (rxByteCount == null) continue;
                totalRxBytes = totalRxBytes + rxByteCount;
            }
            Long aliveDuration = 0L;
            if (biggestLastByteTime != null && smallestFirstByteTime != null) {
                aliveDuration = biggestLastByteTime - smallestFirstByteTime;
            }
            Long activeDuration = aliveDuration - totalGapTime;
            TcpAggregateThroughputTableBean bean = new TcpAggregateThroughputTableBean(GenerateTcpAggregateRxTable.this.getReportPreferences());
            bean.setTcp_aggregate_port(this.port.getName());
            bean.setTcp_aggregate_bytes(totalRxBytes);
            bean.setTcp_aggregate_alive_duration(this.createTimeString(aliveDuration));
            bean.setTcp_aggregate_alive_throughput(this.calculateThroughput(aliveDuration, totalRxBytes));
            bean.setTcp_aggregate_active_duration(this.createTimeString(activeDuration));
            bean.setTcp_aggregate_active_throughput(this.calculateThroughput(activeDuration, totalRxBytes));
            return bean;
        }

        private String createTimeString(Long nanos) {
            if (nanos == null) {
                return "N/A";
            }
            HighResolutionCalendar duration = new HighResolutionCalendar(nanos);
            return HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)duration);
        }

        private double calculateThroughput(long timeInNs, long totalNofBytesReceived) {
            double throughputBps = 0.0;
            long nanosToSeconds = 1000000000L;
            if (timeInNs > 0L && totalNofBytesReceived > 0L) {
                throughputBps = totalNofBytesReceived;
                throughputBps *= 1.0E9;
                throughputBps /= (double)timeInNs;
            }
            return throughputBps;
        }
    }
}

