/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports;

import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.TcpAggregateTxWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.report.generator.jasper.GenerateReport;
import com.excentis.products.byteblower.report.generator.jasper.subreports.GenerateBeanCollectionSubReport;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.TcpAggregateThroughputTableBean;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpFlowInstanceReader;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class GenerateTcpAggregateTxTable
extends GenerateBeanCollectionSubReport {
    public static GenerateTcpAggregateTxTable create(GenerateReport<GenerateReportListener> parentAction, TcpAggregateTxWidgetEntity widget, ReportGeneration reportGeneration) {
        return new GenerateTcpAggregateTxTable(parentAction, widget, reportGeneration);
    }

    private GenerateTcpAggregateTxTable(GenerateReport<GenerateReportListener> parentAction, TcpAggregateTxWidgetEntity widget, ReportGeneration reportGeneration) {
        super(parentAction, (ReportItemWidgetEntity)widget, reportGeneration, (GenerateReportListener)parentAction.getListener());
    }

    @Override
    protected void fillBeans() {
        HashMap<Port, TxTcpAggregation> txAggregationMap = new HashMap<Port, TxTcpAggregation>();
        Scenario scenario = this.getScenario();
        List allTcps = this.getFlowInstanceManager().getAllTcp(scenario);
        for (HttpFlowInstance http : allTcps) {
            HttpFlowInstanceReader reader = EntityReaderFactory.create((HttpFlowInstance)http);
            if (!reader.isConfigured()) continue;
            HttpSession txSession = reader.getSourceHttpSession();
            Port txPort = txSession.getHttpApplication().getPort();
            TxTcpAggregation txAggregation = (TxTcpAggregation)txAggregationMap.get(txPort);
            if (txAggregation == null) {
                txAggregation = new TxTcpAggregation(txPort, this.getReportPreferences());
                txAggregationMap.put(txPort, txAggregation);
            }
            txAggregation.add(txSession);
        }
        for (Port port : txAggregationMap.keySet()) {
            TxTcpAggregation tcpAggregation = (TxTcpAggregation)txAggregationMap.get(port);
            if (!tcpAggregation.valid()) continue;
            this.beans.add(tcpAggregation.createTxBean());
        }
    }

    private FlowInstanceManager getFlowInstanceManager() {
        return new FlowInstanceManager(this.getPersistenceController());
    }

    private static final class TxTcpAggregation {
        private final List<HttpSession> httpSessions = new ArrayList<HttpSession>();
        private final Port port;
        private final ReportPreferencesInterface prefs;
        private boolean hasSessions;

        public TxTcpAggregation(Port port, ReportPreferencesInterface preferences) {
            this.port = port;
            this.hasSessions = false;
            this.prefs = preferences;
        }

        public void add(HttpSession httpSession) {
            if (httpSession != null && httpSession.getTxFirstByteTime() != null) {
                this.httpSessions.add(httpSession);
                this.hasSessions = true;
            }
        }

        public boolean valid() {
            return this.hasSessions;
        }

        protected TcpAggregateThroughputTableBean createTxBean() {
            HttpSession session;
            Collections.sort(this.httpSessions, new Comparator<HttpSession>(){

                @Override
                public int compare(HttpSession lhs, HttpSession rhs) {
                    long lhsTxFirstByteTime = lhs.getTxFirstByteTime();
                    long rhsTxFirstByteTime = rhs.getTxFirstByteTime();
                    return Long.compare(lhsTxFirstByteTime, rhsTxFirstByteTime);
                }
            });
            long aggregateFirstTx = 0L;
            long aggregateLastTx = 0L;
            long gapTime = 0L;
            long totalTxBytes = this.sumTxbytes();
            Iterator<HttpSession> sessionIt = this.httpSessions.iterator();
            if (sessionIt.hasNext()) {
                session = sessionIt.next();
                aggregateFirstTx = session.getTxFirstByteTime();
                aggregateLastTx = session.getTxLastByteTime();
            }
            while (sessionIt.hasNext()) {
                session = sessionIt.next();
                long firstTx = session.getTxFirstByteTime();
                if (firstTx > aggregateLastTx) {
                    gapTime += firstTx - aggregateLastTx;
                }
                aggregateLastTx = Math.max(aggregateLastTx, session.getTxLastByteTime());
            }
            long aliveDuration = 0L;
            long activeDuration = 0L;
            if (totalTxBytes > 0L) {
                aliveDuration = aggregateLastTx - aggregateFirstTx;
                activeDuration = aliveDuration - gapTime;
            }
            TcpAggregateThroughputTableBean bean = new TcpAggregateThroughputTableBean(this.prefs);
            bean.setTcp_aggregate_port(this.port.getName());
            bean.setTcp_aggregate_bytes(totalTxBytes);
            bean.setTcp_aggregate_alive_duration(this.createTimeString(aliveDuration));
            bean.setTcp_aggregate_alive_throughput(this.calculateThroughput(aliveDuration, totalTxBytes));
            bean.setTcp_aggregate_active_duration(this.createTimeString(activeDuration));
            bean.setTcp_aggregate_active_throughput(this.calculateThroughput(activeDuration, totalTxBytes));
            return bean;
        }

        private long sumTxbytes() {
            long transmitted = 0L;
            for (HttpSession session : this.httpSessions) {
                Long txSession = session.getTxByteCount();
                if (txSession == null) continue;
                transmitted += txSession.longValue();
            }
            return transmitted;
        }

        private String createTimeString(Long nanos) {
            if (nanos == null) {
                return "N/A";
            }
            HighResolutionCalendar duration = new HighResolutionCalendar(nanos);
            return HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)duration);
        }

        private double calculateThroughput(long timeInNs, long totalNofBytesReceived) {
            double throughputBps = 0.0;
            long nanosToSeconds = 1000000000L;
            if (timeInNs > 0L && totalNofBytesReceived > 0L) {
                throughputBps = totalNofBytesReceived;
                throughputBps *= 1.0E9;
                throughputBps /= (double)timeInNs;
            }
            return throughputBps;
        }
    }
}

