/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports;

import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.WarningInfoTableWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.jasper.GenerateReport;
import com.excentis.products.byteblower.report.generator.jasper.subreports.GenerateBeanCollectionSubReport;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.EventInfoTableBean;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.entities.Event;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstanceEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.PortEvent;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class GenerateWarningInfoTable
extends GenerateBeanCollectionSubReport {
    public static GenerateWarningInfoTable create(GenerateReport<GenerateReportListener> parentAction, WarningInfoTableWidgetEntity widget, ReportGeneration reportGeneration) {
        return new GenerateWarningInfoTable(parentAction, widget, reportGeneration);
    }

    private GenerateWarningInfoTable(GenerateReport<GenerateReportListener> parentAction, WarningInfoTableWidgetEntity widget, ReportGeneration reportGeneration) {
        super(parentAction, (ReportItemWidgetEntity)widget, reportGeneration, (GenerateReportListener)parentAction.getListener());
    }

    @Override
    protected void fillBeans() {
        EventManager manager = this.getWarningManager();
        List events = manager.getEntities();
        Collections.sort(events, new Comparator<Event>(){

            @Override
            public int compare(Event o1, Event o2) {
                int dateCompare = o1.getEventTime().compareTo(o2.getEventTime());
                if (dateCompare != 0) {
                    return dateCompare;
                }
                if (o1 instanceof FlowInstanceEvent && o2 instanceof FlowInstanceEvent) {
                    return ((FlowInstanceEvent)o1).getFlowInstance().getScenarioPosition().compareTo(((FlowInstanceEvent)o2).getFlowInstance().getScenarioPosition());
                }
                if (o1 instanceof PortEvent && o2 instanceof PortEvent) {
                    return ((PortEvent)o1).getPort().getId().compareTo(((PortEvent)o2).getPort().getId());
                }
                return 0;
            }
        });
        for (Event event : events) {
            if (event.getSeverity() != EventSeverity.TEST_WARNING) continue;
            EventInfoTableBean bean = new EventInfoTableBean(event);
            this.beans.add(bean);
        }
    }

    private EventManager getWarningManager() {
        return new EventManager(this.getPersistenceController());
    }
}

