/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports.beans;

import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.report.generator.core.parameters.DataRateUnitParameter;
import com.excentis.products.byteblower.report.generator.core.parameters.LatencyUnitParameter;
import com.excentis.products.byteblower.report.generator.core.parameters.LossLevelParameter;
import com.excentis.products.byteblower.report.generator.core.parameters.ParameterConvertor;
import com.excentis.products.byteblower.report.generator.core.parameters.ThroughputPatternParameter;
import com.excentis.products.byteblower.report.generator.core.parameters.ThroughputTypeParameter;
import com.excentis.products.byteblower.results.testdata.data.entities.Event;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import com.excentis.products.byteblower.results.testdata.data.utils.EthernetThroughputType;
import com.excentis.products.byteblower.results.testdata.data.utils.LatencyUnit;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;

abstract class AbstractBean {
    protected final DataRateUnit dataRateUnit;
    protected final LatencyUnit latencyUnit;
    protected final EthernetThroughputType throughputType;
    protected final LossLevelParameter errorLosParameter;
    protected final LossLevelParameter warningLosParameter;
    protected final ThroughputPatternParameter throughputPatternParameter;
    protected final List<? extends Event> eventList;

    AbstractBean() {
        this(Collections.emptyList());
    }

    AbstractBean(ReportPreferencesInterface preferences) {
        this(preferences, Collections.emptyList());
    }

    AbstractBean(ReportPreferencesInterface preferences, List<? extends Event> events) {
        this.dataRateUnit = ParameterConvertor.convertDataRateUnit((DataRateUnitParameter)preferences.getDataRateUnit());
        this.throughputType = ParameterConvertor.convertThroughputType((ThroughputTypeParameter)preferences.getThroughputType());
        this.latencyUnit = ParameterConvertor.convertLatencyUnit((LatencyUnitParameter)preferences.getLatencyUnit());
        this.throughputPatternParameter = preferences.getThroughputPattern();
        this.errorLosParameter = preferences.getErrorLossLevel();
        this.warningLosParameter = preferences.getWarningLossLevel();
        this.eventList = events;
    }

    AbstractBean(List<? extends Event> events) {
        this.dataRateUnit = DataRateUnit.KILOBIT_PER_SECOND;
        this.latencyUnit = LatencyUnit.MILLISECONDS;
        this.throughputPatternParameter = new ThroughputPatternParameter(2);
        this.throughputType = EthernetThroughputType.FRAME_ONLY;
        this.errorLosParameter = LossLevelParameter.errorLevel((double)0.0);
        this.warningLosParameter = LossLevelParameter.warningLevel((double)0.0);
        this.eventList = events;
    }

    protected String decorateWithEventColors(String text) {
        boolean hasWarning = false;
        String escaped = StringEscapeUtils.escapeHtml3((String)text);
        if (this.eventList.isEmpty()) {
            return escaped;
        }
        for (Event event : this.eventList) {
            if (event.getSeverity() == EventSeverity.TEST_ERROR) {
                return this.makeRed(escaped);
            }
            if (event.getSeverity() != EventSeverity.TEST_WARNING) continue;
            hasWarning = true;
        }
        if (hasWarning) {
            return this.makePurple(escaped);
        }
        return escaped;
    }

    protected String makeOrange(String text) {
        return this.addColorToText(text, "#F7941C");
    }

    protected String makePurple(String text) {
        return this.addColorToText(text, "#EC08C0");
    }

    protected String makeRed(String text) {
        return this.addColorToText(text, "#ED1B23");
    }

    private String addColorToText(String text, String color) {
        StringBuilder buf = new StringBuilder();
        buf.append("<font color=\"");
        buf.append(color);
        buf.append("\">");
        buf.append(text);
        buf.append("</font>");
        return buf.toString();
    }

    protected String makeItalic(String text) {
        StringBuilder buf = new StringBuilder();
        buf.append("<i>");
        buf.append(text);
        buf.append("</i>");
        return buf.toString();
    }
}

