/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports.beans;

import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.AbstractBean;
import com.excentis.products.byteblower.results.testdata.data.entities.Event;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstanceEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.NatAddressMappingEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.PortEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.ServerEvent;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import java.util.Date;

public class EventInfoTableBean
extends AbstractBean {
    private Event event;
    private String hyperlink = new String();
    private String description = new String();

    public EventInfoTableBean(Event event) {
        this.event = event;
        this.description = event.getDescription();
        this.hyperlink = event.getKnowledgebaseLink();
    }

    public EventInfoTableBean() {
        this(new Event(new Date(), "", EventSeverity.TEST_INFO));
    }

    public Date getEvent_info_time() {
        return this.event.getEventTime();
    }

    public String getEvent_info_description() {
        return this.description;
    }

    public String getEvent_object_name() {
        if (this.event instanceof PortEvent) {
            PortEvent p = (PortEvent)this.event;
            Port port = p.getPort();
            return port != null ? port.getName() : "";
        }
        if (this.event instanceof FlowInstanceEvent) {
            FlowInstanceEvent flow = (FlowInstanceEvent)this.event;
            return flow.getFlowInstance().getFlow().getName();
        }
        if (this.event instanceof ServerEvent) {
            ServerEvent server = (ServerEvent)this.event;
            return server.getServer().getUrl();
        }
        if (this.event instanceof NatAddressMappingEvent) {
            NatAddressMappingEvent nat = (NatAddressMappingEvent)this.event;
            return nat.getAddressMapping().getResolverPort().getName();
        }
        return "";
    }

    public Boolean getEvent_hyperlink_type() {
        return !this.hyperlink.isEmpty();
    }

    public String getEvent_info_hyperlink() {
        return this.hyperlink;
    }
}

