/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports.beans;

import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.AbstractBean;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfig;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfigFixedIpv4;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfigFixedIpv6;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatency;
import com.excentis.products.byteblower.results.testdata.data.entities.FbOutOfSequence;
import com.excentis.products.byteblower.results.testdata.data.entities.FbSource;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTrigger;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstanceEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv6Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer25;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer25Vlan;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbLatencyReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbOutOfSequenceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbTriggerReader;
import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv4AddressUtility;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv6AddressUtility;
import com.excentis.products.byteblower.results.testdata.data.utils.ThroughputReader;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Set;

public class FrameBlastingTableBean
extends AbstractBean {
    private static final String INVALID = "N/A";
    private FbFlowInstanceReader flowReader;
    private FbSource source;
    private FbDestination destination;
    private FbTrigger sourceTrigger;
    private FbTriggerReader sourceTriggerReader;
    private FbTrigger destinationTrigger;
    private FbTriggerReader destinationTriggerReader;
    private FbLatency latency;
    private FbLatencyReader latencyReader;
    private FbOutOfSequence outOfSequence;
    private FbOutOfSequenceReader outOfSequenceReader;
    private FbDestinationConfig destinationConfig;

    public FrameBlastingTableBean(FbFlowInstance fbFlowInstance, FbDestination destination, ReportPreferencesInterface prefs, List<FlowInstanceEvent> events) {
        super(prefs, events);
        this.flowReader = EntityReaderFactory.create((FbFlowInstance)fbFlowInstance);
        this.source = this.flowReader.getSource();
        this.destination = destination;
        this.sourceTrigger = this.source == null ? null : this.source.getTrigger();
        if (this.sourceTrigger != null) {
            this.sourceTriggerReader = EntityReaderFactory.create((FbTrigger)this.sourceTrigger);
        }
        this.destinationTrigger = this.destination == null ? null : destination.getTrigger();
        if (this.destinationTrigger != null) {
            this.destinationTriggerReader = EntityReaderFactory.create((FbTrigger)this.destinationTrigger);
        }
        this.latency = destination.getLatency();
        if (this.latency != null) {
            this.latencyReader = EntityReaderFactory.create((FbLatency)this.latency);
        }
        this.outOfSequence = destination.getOutOfSequence();
        if (this.outOfSequence != null) {
            this.outOfSequenceReader = EntityReaderFactory.create((FbOutOfSequence)this.outOfSequence);
        }
        this.destinationConfig = fbFlowInstance.getDestinationConfig();
    }

    public FrameBlastingTableBean(FbFlowInstance fbFlowInstance, FbDestinationConfig config, ReportPreferencesInterface prefs) {
        super(prefs);
        this.flowReader = EntityReaderFactory.create((FbFlowInstance)fbFlowInstance);
        this.destinationConfig = config;
        this.source = this.flowReader.getSource();
        this.sourceTrigger = this.source.getTrigger();
        if (this.sourceTrigger != null) {
            this.sourceTriggerReader = EntityReaderFactory.create((FbTrigger)this.sourceTrigger);
        }
        if (this.source == null) {
            this.sourceTrigger = null;
        }
        this.destination = null;
        this.destinationTrigger = null;
        this.latency = null;
        this.latencyReader = null;
        this.outOfSequence = null;
    }

    public String getFrame_blasting_flow() {
        return this.decorateWithEventColors(this.flowReader.getName());
    }

    public String getFrame_blasting_source() {
        if (this.source == null) {
            return new String();
        }
        return this.source.getPort().getName();
    }

    public String getFrame_blasting_destination() {
        if (this.destination == null) {
            if (this.destinationConfig instanceof FbDestinationConfigFixedIpv4) {
                FbDestinationConfigFixedIpv4 conf = (FbDestinationConfigFixedIpv4)this.destinationConfig;
                return this.toString(conf.getIpv4Address());
            }
            if (this.destinationConfig instanceof FbDestinationConfigFixedIpv6) {
                FbDestinationConfigFixedIpv6 conf = (FbDestinationConfigFixedIpv6)this.destinationConfig;
                return this.toString(conf.getIpv6Address());
            }
            return new String();
        }
        if (this.isEavesdropper()) {
            return this.makeItalic(this.destination.getPort().getName());
        }
        return this.destination.getPort().getName();
    }

    private boolean isEavesdropper() {
        Set eavesdroppers = this.destinationConfig.getEavesdroppers();
        if (eavesdroppers.isEmpty()) {
            return false;
        }
        return eavesdroppers.contains(this.destination);
    }

    private String decorateLoss(double loss, String text) {
        double errorLevel = this.errorLosParameter.level() * 100.0;
        double warningLevel = this.warningLosParameter.level() * 100.0;
        if (loss < 0.0) {
            return this.makePurple(text);
        }
        if (loss < warningLevel) {
            return text;
        }
        if (loss >= warningLevel && loss < errorLevel) {
            return this.makeOrange(text);
        }
        return this.makeRed(text);
    }

    public String getFrame_blasting_duration() {
        boolean no_RX_duration;
        String postfix = "";
        if (this.destinationTrigger == null || this.destinationTrigger.getPacketCount() < 2L) {
            return INVALID;
        }
        Long firstPacket = this.destinationTrigger.getFirstPacketTime();
        Long lastPacket = this.destinationTrigger.getLastPacketTime();
        boolean bl = no_RX_duration = firstPacket == null || lastPacket == null;
        if (no_RX_duration && this.sourceTrigger != null && 0L != this.sourceTrigger.getPacketCount()) {
            firstPacket = this.sourceTrigger.getFirstPacketTime();
            lastPacket = this.sourceTrigger.getLastPacketTime();
            postfix = " (Tx)";
        }
        if (firstPacket == null || lastPacket == null) {
            return INVALID;
        }
        long nanos = lastPacket - firstPacket;
        return String.valueOf(HighResolutionCalendarParser.getRelativeTime((long)nanos)) + postfix;
    }

    public long getFrame_blasting_frame_tx() {
        if (this.sourceTrigger == null) {
            return 0L;
        }
        return this.sourceTrigger.getPacketCount();
    }

    public long getFrame_blasting_frame_rx() {
        if (this.destinationTrigger == null) {
            return 0L;
        }
        return this.destinationTrigger.getPacketCount();
    }

    public String getFrame_blasting_frame_rx_formatted() {
        if (this.destinationTrigger == null) {
            return null;
        }
        return NumberFormat.getInstance().format(this.getFrame_blasting_frame_rx());
    }

    private boolean hasRxTrigger() {
        return this.destinationTrigger != null;
    }

    public String getFrame_blasting_frame_loss() {
        if (this.hasRxTrigger()) {
            long tx = this.getFrame_blasting_frame_tx();
            long rx = this.getFrame_blasting_frame_rx();
            return this.relativeLossText(tx, rx);
        }
        return INVALID;
    }

    public String getFrame_blasting_byte_loss() {
        if (this.hasRxTrigger()) {
            long tx = this.getFrame_blasting_byte_tx();
            long rx = this.getFrame_blasting_byte_rx();
            return this.relativeLossText(tx, rx);
        }
        return INVALID;
    }

    private String relativeLossText(long tx, long rx) {
        if (tx == 0L) {
            return INVALID;
        }
        double loss = (double)(100L * (tx - rx)) / (double)tx;
        StringBuffer result = new StringBuffer();
        DecimalFormat decimalLoss = new DecimalFormat("0.00");
        if (loss > 0.0 && loss < 0.005) {
            result.append("~");
        }
        result.append(decimalLoss.format(loss));
        result.append("%");
        return this.decorateLoss(loss, result.toString());
    }

    public Long getFrame_blasting_byte_tx() {
        if (this.sourceTriggerReader == null) {
            return null;
        }
        return this.sourceTriggerReader.getByteCount() - this.getFrame_blasting_byte_tx_vlan();
    }

    public String getFrame_blasting_byte_tx_formatted() {
        Long bytes = this.getFrame_blasting_byte_tx();
        if (bytes == null) {
            return null;
        }
        return NumberFormat.getInstance().format(bytes);
    }

    public Long getFrame_blasting_byte_tx_vlan() {
        if (this.sourceTriggerReader == null || this.source.getPort().getLayer2() == null) {
            return 0L;
        }
        List vlanlist = this.source.getPort().getLayer2().getLayer25List();
        int nestingDepth = 0;
        for (Layer25 vlan : vlanlist) {
            if (!(vlan instanceof Layer25Vlan)) continue;
            ++nestingDepth;
        }
        return this.getFrame_blasting_frame_tx() * (long)(4 * nestingDepth);
    }

    public String getFrame_blasting_byte_tx_vlan_formatted() {
        Long bytes = this.getFrame_blasting_byte_tx_vlan();
        if (bytes == null) {
            return null;
        }
        return NumberFormat.getInstance().format(bytes);
    }

    public Boolean getFrame_blasting_rx_has_vlan() {
        if (this.destinationTriggerReader == null || this.destination.getPort().getLayer2() == null) {
            return Boolean.FALSE;
        }
        List vlanlist = this.destination.getPort().getLayer2().getLayer25List();
        for (Layer25 vlan : vlanlist) {
            if (!(vlan instanceof Layer25Vlan)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean getFrame_blasting_tx_has_vlan() {
        if (this.sourceTriggerReader == null || this.source.getPort().getLayer2() == null) {
            return Boolean.FALSE;
        }
        List vlanlist = this.source.getPort().getLayer2().getLayer25List();
        for (Layer25 vlan : vlanlist) {
            if (!(vlan instanceof Layer25Vlan)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public long getFrame_blasting_byte_rx() {
        if (this.destinationTriggerReader == null) {
            return 0L;
        }
        return this.destinationTriggerReader.getByteCount() - this.getFrame_blasting_byte_rx_vlan();
    }

    public String getFrame_blasting_byte_rx_formatted() {
        if (this.destinationTriggerReader == null) {
            return null;
        }
        long bytes = this.getFrame_blasting_byte_rx();
        return NumberFormat.getInstance().format(bytes);
    }

    public Long getFrame_blasting_byte_rx_vlan() {
        if (!this.getFrame_blasting_rx_has_vlan().booleanValue()) {
            return 0L;
        }
        List vlanlist = this.destination.getPort().getLayer2().getLayer25List();
        int nestingDepth = 0;
        for (Layer25 vlan : vlanlist) {
            if (!(vlan instanceof Layer25Vlan)) continue;
            ++nestingDepth;
        }
        return this.getFrame_blasting_frame_rx() * (long)(4 * nestingDepth);
    }

    public String getFrame_blasting_byte_rx_vlan_formatted() {
        Long bytes = this.getFrame_blasting_byte_rx_vlan();
        if (bytes == null) {
            return null;
        }
        return NumberFormat.getInstance().format(bytes);
    }

    public String getFrame_blasting_throughput() {
        Double throughput = null;
        String postfix = new String();
        if (this.destinationTriggerReader == null) {
            return null;
        }
        if (this.destinationTriggerReader.getByteCount() == 0L) {
            return "0";
        }
        if (this.sourceTrigger != null && (this.destinationTrigger.getLastPacketTime() == null || this.destinationTrigger.getFirstPacketTime() == null)) {
            Double throughputBps = this.sourceTriggerReader.getThroughputBitsPerSecond(this.throughputType);
            if (throughputBps != null) {
                long tx = this.getFrame_blasting_byte_tx();
                long rx = this.getFrame_blasting_byte_rx();
                double rxEstimate = throughputBps * ((double)rx / (double)tx);
                throughput = ThroughputReader.convertThroughput((Double)rxEstimate, (DataRateUnit)DataRateUnit.BIT_PER_SECOND, (DataRateUnit)this.dataRateUnit);
                postfix = " (Est.)";
            }
        } else {
            throughput = this.destinationTriggerReader.getThroughput(this.throughputType, this.dataRateUnit);
        }
        if (throughput != null) {
            return String.valueOf(this.throughputPatternParameter.format(throughput.doubleValue())) + postfix;
        }
        return null;
    }

    public boolean hasLatency() {
        return this.latencyReader != null;
    }

    public Double getFrame_blasting_latency_min() {
        if (this.latencyReader == null) {
            return null;
        }
        return this.latencyReader.getLatencyMinimum(this.latencyUnit);
    }

    public Double getFrame_blasting_latency_avg() {
        if (this.latencyReader == null) {
            return null;
        }
        return this.latencyReader.getLatencyAverage(this.latencyUnit);
    }

    public Double getFrame_blasting_latency_max() {
        if (this.latencyReader == null) {
            return null;
        }
        return this.latencyReader.getLatencyMaximum(this.latencyUnit);
    }

    public Double getFrame_blasting_latency_jitter() {
        if (this.latencyReader == null) {
            return null;
        }
        return this.latencyReader.getJitter(this.latencyUnit);
    }

    public boolean hasOos() {
        return this.outOfSequenceReader != null;
    }

    public Long getFrame_blasting_oos() {
        if (this.outOfSequenceReader == null) {
            return null;
        }
        return this.outOfSequenceReader.getPacketCountOutOfSequence();
    }

    private String toString(Ipv4Address address) {
        if (address == null) {
            return null;
        }
        return Ipv4AddressUtility.convertToString((byte[])address.getAddress());
    }

    private String toString(Ipv6Address address) {
        if (address == null) {
            return null;
        }
        return Ipv6AddressUtility.convertToExpandedString((byte[])address.getAddress());
    }
}

