/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports.beans;

import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.AbstractBean;
import com.excentis.products.byteblower.results.testdata.data.entities.NatAddressMapping;
import com.excentis.products.byteblower.results.testdata.data.entities.NatPortMapping;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.PortReader;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv4AddressUtility;

public class IPv4NatPortTableBean
extends AbstractBean {
    private PortReader portReader;
    private NatAddressMapping addressMapping;
    private NatPortMapping portMapping;

    public IPv4NatPortTableBean(Port port, NatAddressMapping addressMapping, NatPortMapping portMapping) {
        this.portReader = EntityReaderFactory.create((Port)port);
        this.addressMapping = addressMapping;
        this.portMapping = portMapping;
    }

    public String getNat_bb_port_private() {
        return this.addressMapping.getTargetPort().getName();
    }

    public String getNat_bb_port_public() {
        return this.addressMapping.getResolverPort().getName();
    }

    public String getNat_port_private_ip() {
        return this.portReader.getIPv4Address();
    }

    public String getNat_port_public_ip() {
        return String.valueOf(Ipv4AddressUtility.convertToString((byte[])this.addressMapping.getPublicAddress().getAddress())) + " (" + this.addressMapping.getMethod() + ")";
    }

    public String getNat_port_protocol() {
        return this.portMapping.getProtocol().name();
    }

    public String getNat_port_private_port() {
        return this.portMapping.getPrivatePort().toString();
    }

    public String getNat_port_public_port() {
        return String.valueOf(this.portMapping.getPublicPort().toString()) + " (" + this.portMapping.getMethod() + ")";
    }
}

