/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports.beans;

import com.excentis.products.byteblower.results.testdata.data.entities.Interface;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer2;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer2EthernetII;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4ConfigurationStatic;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6ConfigurationStatic;
import com.excentis.products.byteblower.results.testdata.data.entities.MacAddress;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.Server;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv4AddressUtility;
import com.excentis.products.byteblower.results.testdata.data.utils.MacAddressUtility;
import com.excentis.products.byteblower.results.testdata.data.utils.Pair;

public class PortOverviewBean {
    private Port port;
    private final String addressTypeIPv4 = "ipv4";
    private final String addressTypeIPv6 = "ipv6";
    private final String addressTypeNotSupported = "address_type_not_supported";
    private final String layer2NotSupported = "layer2_not_supported";

    public PortOverviewBean(Port port) {
        this.port = port;
    }

    private String toString(Ipv4Address address) {
        return Ipv4AddressUtility.convertToString((byte[])address.getAddress());
    }

    private String toString(MacAddress address) {
        return MacAddressUtility.convertFromBinary((byte[])address.getAddress());
    }

    private Interface getInterface() {
        return this.port.getInterface();
    }

    private Server getServer() {
        return this.getInterface().getServer();
    }

    public Long getServer_id() {
        return this.getServer().getId();
    }

    public Long getInterface_id() {
        return this.getInterface().getId();
    }

    public String getPort_address_type() {
        Layer3 layer3 = this.port.getLayer3();
        if (layer3 instanceof Layer3Ipv4) {
            return "ipv4";
        }
        if (layer3 instanceof Layer3Ipv6) {
            return "ipv6";
        }
        return "address_type_not_supported";
    }

    public String getPort_number() {
        return "123";
    }

    public String getPort_name() {
        return this.port.getName();
    }

    public String getPort_mac() {
        Layer2 layer2 = this.port.getLayer2();
        if (layer2 instanceof Layer2EthernetII) {
            Layer2EthernetII ethII = (Layer2EthernetII)layer2;
            return this.toString(ethII.getMacAddress());
        }
        return "layer2_not_supported";
    }

    private Layer3 getLayer3() {
        return this.port.getLayer3();
    }

    private Layer3Ipv4 getIPv4() {
        Layer3 layer3 = this.getLayer3();
        if (layer3 instanceof Layer3Ipv4) {
            return (Layer3Ipv4)this.getLayer3();
        }
        return null;
    }

    private Layer3Ipv6 getIPv6() {
        Layer3 layer3 = this.getLayer3();
        if (layer3 instanceof Layer3Ipv6) {
            return (Layer3Ipv6)this.getLayer3();
        }
        return null;
    }

    private Layer3Ipv4ConfigurationStatic getStaticIPv4() {
        Layer3Ipv4 ipv4 = this.getIPv4();
        return ipv4.getFixedConfiguration();
    }

    private boolean isIPv4() {
        return this.getIPv4() != null;
    }

    public String getPort_ipv4_address() {
        if (!this.isIPv4()) {
            return null;
        }
        return this.toString(this.getStaticIPv4().getAddress());
    }

    public String getPort_ipv4_netmask() {
        if (!this.isIPv4()) {
            return null;
        }
        return this.getStaticIPv4().getNetmaskValue().toString();
    }

    public String getPort_ipv4_gateway() {
        if (!this.isIPv4()) {
            return null;
        }
        return this.toString(this.getStaticIPv4().getGateway());
    }

    public String getPort_ipv4_method() {
        if (!this.isIPv4()) {
            return null;
        }
        return this.getIPv4().getMethod().toString();
    }

    public String getPort_ipv4_nat() {
        if (!this.isIPv4()) {
            return null;
        }
        return this.getIPv4().getNatConfiguration().toString();
    }

    private boolean isIPv6() {
        return this.getIPv6() != null;
    }

    private Layer3Ipv6ConfigurationStatic getStaticIPv6() {
        if (!this.isIPv6()) {
            return null;
        }
        return this.getIPv6().getStaticConfiguration();
    }

    public String getPort_ipv6_address() {
        if (!this.isIPv6()) {
            return null;
        }
        String addresses = null;
        for (Pair pair : this.getStaticIPv6().getAddresses()) {
            if (addresses != null) {
                addresses = String.valueOf(addresses) + ", ";
            }
            addresses = String.valueOf(addresses) + pair.getFirst();
        }
        return addresses;
    }

    public String getPort_ipv6_address_prefix_size() {
        if (!this.isIPv6()) {
            return null;
        }
        String prefixes = null;
        for (Pair pair : this.getStaticIPv6().getAddresses()) {
            if (prefixes != null) {
                prefixes = String.valueOf(prefixes) + ", ";
            }
            prefixes = String.valueOf(prefixes) + pair.getSecond();
        }
        return prefixes;
    }

    public String getPort_ipv6_gateway() {
        if (!this.isIPv6()) {
            return null;
        }
        String gateways = null;
        for (Pair pair : this.getStaticIPv6().getGatewayAddresses()) {
            if (gateways != null) {
                gateways = String.valueOf(gateways) + ", ";
            }
            gateways = String.valueOf(gateways) + pair.getSecond();
        }
        return gateways;
    }

    public String getPort_ipv6_method() {
        if (!this.isIPv6()) {
            return null;
        }
        return "IPV6_METHOD_TODO";
    }

    public String getInterface_type() {
        return this.getInterface().getCode().getType();
    }

    public String getInterface_mac() {
        return "MAC_TODO";
    }

    public String getServer_name() {
        return this.getServer().getUrl();
    }

    public String getServer_ip() {
        return this.toString(this.getServer().getIpv4Address());
    }

    public String getServer_version() {
        return this.getServer().getVersion();
    }

    public String getServer_revision() {
        return "REVISION_TODO";
    }
}

