/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports.beans;

import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.AbstractBean;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.testdata.data.entities.Event;
import com.excentis.products.byteblower.results.testdata.data.entities.Server;
import com.excentis.products.byteblower.results.testdata.data.entities.Test;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import com.excentis.products.byteblower.results.testdata.data.enums.TestStatus;
import com.excentis.products.byteblower.results.testdata.data.enums.TestType;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv4AddressUtility;
import java.util.Date;
import java.util.List;

public class ScenarioInfoBean
extends AbstractBean {
    private final TestDataReference tdr;
    private final Test test;
    private String serverText;

    public ScenarioInfoBean(TestDataReference testdata, Test test, List<Event> events) {
        super(events);
        this.tdr = testdata;
        this.test = test == null ? new Test("Cancelled", "", "", TestType.SCENARIOTEST, "", "") : test;
        this.serverText = "";
    }

    public String getProjectName() {
        return this.test.getProjectName();
    }

    public String getProjectAuthor() {
        return this.test.getProjectAuthor();
    }

    public String getProjectVersion() {
        return this.test.getProjectVersion();
    }

    public String getRunTitle() {
        String runTitle = this.test.getRunTitle();
        return runTitle != null ? runTitle : "-";
    }

    public Date getStartTime() {
        return this.tdr.getStartTime();
    }

    public Date getEndTime() {
        Date when = this.tdr.getEndTime();
        if (when == null) {
            return this.tdr.getStartTime();
        }
        return when;
    }

    public String getStatus() {
        if (this.test.getStatus() == TestStatus.ERROR) {
            return this.makeRed(this.test.getStatus().toString());
        }
        return this.decorateWithEventColors(this.test.getStatus().toString());
    }

    public String getTestName() {
        return this.test.getName();
    }

    public String getServers() {
        return this.serverText;
    }

    @Override
    protected String decorateWithEventColors(String text) {
        boolean hasWarning = false;
        if (this.eventList.isEmpty()) {
            return text;
        }
        for (Event e : this.eventList) {
            if (e.getSeverity() == EventSeverity.TEST_ERROR) {
                StringBuffer buf = new StringBuffer();
                buf.append(text);
                buf.append(" ");
                buf.append(this.makeRed("(with errors)"));
                return buf.toString();
            }
            if (e.getSeverity() != EventSeverity.TEST_WARNING) continue;
            hasWarning = true;
        }
        if (hasWarning) {
            StringBuffer buf = new StringBuffer();
            buf.append(text);
            buf.append(" ");
            buf.append(this.makePurple("(with warnings)"));
            return buf.toString();
        }
        return text;
    }

    public void setServers(List<Server> serverList) {
        StringBuilder buffer = new StringBuilder();
        String header = "";
        for (Server server : serverList) {
            String name = server.getName();
            String addr = "Unknown";
            if (server.getIpv4Address() != null) {
                addr = Ipv4AddressUtility.convertToString((byte[])server.getIpv4Address().getAddress());
            }
            buffer.append(header);
            buffer.append(header);
            buffer.append(name);
            if (!name.equals(addr)) {
                buffer.append(" [");
                buffer.append(addr);
                buffer.append("]");
            }
            buffer.append("\n");
            if (server.getType() != null && server.getVersion() != null) {
                buffer.append(server.getType());
                buffer.append(" - ");
                buffer.append(server.getVersion());
            }
            header = "\n";
        }
        this.serverText = buffer.toString();
    }
}

