/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports.beans;

import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.AbstractBean;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstanceEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.enums.HttpRequestMethod;
import java.util.List;

public class TcpInfoTableBean
extends AbstractBean {
    private HttpFlowInstance httpFlow;
    private HttpFlowInstanceReader httpFlowReader;

    public TcpInfoTableBean(HttpFlowInstance flowInstance, ReportPreferencesInterface pref, List<FlowInstanceEvent> events) {
        super(pref, events);
        this.httpFlow = flowInstance;
        this.httpFlowReader = EntityReaderFactory.create((HttpFlowInstance)flowInstance);
    }

    public String getTcp_info_flow() {
        return this.decorateWithEventColors(this.httpFlowReader.getName());
    }

    public String getTcp_info_template() {
        return this.httpFlow.getFlowTemplate().getName();
    }

    public String getTcp_info_start() {
        return this.httpFlowReader.getStart();
    }

    public String getTcp_info_http_method() {
        HttpRequestMethod requestMethod = this.httpFlow.getRequestMethod();
        if (requestMethod == null) {
            return "";
        }
        return this.httpFlow.getRequestMethod().toString();
    }

    public Long getTcp_info_payload() {
        Long payload = this.httpFlow.getFlowTemplate().getHttpDataSize();
        if (payload == null) {
            return null;
        }
        return payload;
    }

    public String getTcp_info_duration() {
        return this.httpFlowReader.getDuration();
    }

    public String getTcp_info_initialreceivewindowscale() {
        Integer scale = this.httpFlow.getFlowTemplate().getRxWindowScaleValue();
        return scale == null ? "None" : String.valueOf(scale.toString()) + " (multiply with " + (1 << scale) + ")";
    }

    public Integer getTcp_info_initialreceivewindow() {
        return this.httpFlow.getFlowTemplate().getRxWindowInitialUnscaledSize();
    }

    public Double getTcp_info_ratelimit() {
        Double rateLimit = this.httpFlowReader.getRateLimit(this.dataRateUnit);
        if (rateLimit == null) {
            return null;
        }
        return rateLimit;
    }

    public String getTcp_info_tos() {
        return this.httpFlowReader.getTos();
    }
}

