/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports.beans;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.AbstractBean;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstanceEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotRetransmissionCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpSessionReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.PortReader;
import com.excentis.products.byteblower.results.testdata.data.utils.LatencyUnit;
import java.util.List;

public class TcpTableBean
extends AbstractBean {
    private HttpFlowInstanceReader httpFlowReader;
    private HttpSession httpSourceSession;
    private HttpSession httpDestinationSession;
    private HttpSessionReader httpDestinationSessionReader;
    private PortReader httpSourceReader;
    private PortReader httpDestinationReader;
    private TcpSessionSnapshot cumulative;
    private TcpSessionSnapshotRetransmissionCounters retransmit;
    private Long ttfb;

    public TcpTableBean(HttpFlowInstance httpFlowInstance, TcpSessionSnapshot cumulative, TcpSessionSnapshotRetransmissionCounters retransmit, ReportPreferencesInterface prefs, List<FlowInstanceEvent> errors, TestDataPersistenceController pc) {
        super(prefs, errors);
        this.httpFlowReader = EntityReaderFactory.create((HttpFlowInstance)httpFlowInstance);
        this.httpSourceSession = this.httpFlowReader.getSourceHttpSession();
        this.httpSourceReader = this.httpFlowReader.getSourceReader();
        this.httpDestinationSession = this.httpFlowReader.getDestinationHttpSession();
        this.httpDestinationSessionReader = this.httpDestinationSession != null ? EntityReaderFactory.create((HttpSession)this.httpDestinationSession) : null;
        this.httpDestinationReader = this.httpFlowReader.getDestinationReader();
        this.cumulative = cumulative;
        this.retransmit = retransmit;
        this.ttfb = this.httpFlowReader.calculateTTFBNanoseconds(pc);
    }

    public String getTcp_flow() {
        return this.decorateWithEventColors(this.httpFlowReader.getName());
    }

    public String getTcp_source() {
        if (this.httpSourceReader == null) {
            return null;
        }
        return this.httpSourceReader.getName();
    }

    public String getTcp_destination() {
        if (this.httpDestinationReader == null) {
            return null;
        }
        return this.httpDestinationReader.getName();
    }

    public Long getTcp_tx_payload_bytes() {
        if (this.httpSourceSession == null) {
            return null;
        }
        return this.httpSourceSession.getTxByteCount();
    }

    public Long getTcp_rx_payload_bytes() {
        if (this.httpDestinationSession == null) {
            return null;
        }
        return this.httpDestinationSession.getRxByteCount();
    }

    public String getTcp_duration() {
        HttpSessionReader reader;
        Long targetDuration = this.httpFlowReader.getDurationNanoseconds();
        if (this.httpDestinationSessionReader != null && this.httpDestinationSessionReader.getRxDurationNanoseconds() != null) {
            float range;
            long actualDuration = Math.max(1L, this.httpDestinationSessionReader.getRxDurationNanoseconds());
            String rxDuration = this.httpDestinationSessionReader.getRxDuration();
            if (targetDuration > 0L && 0.9 > (double)(range = (float)actualDuration / (float)targetDuration.longValue())) {
                rxDuration = this.makeRed(rxDuration);
            }
            return rxDuration;
        }
        if (this.httpSourceReader != null && (reader = EntityReaderFactory.create((HttpSession)this.httpSourceSession)).getTxDurationNanoseconds() != null) {
            float range;
            long actualDuration = Math.max(1L, reader.getTxDurationNanoseconds());
            String txt = String.valueOf(reader.getTxDuration()) + " (Tx)";
            if (targetDuration > 0L && 0.9 > (double)(range = (float)actualDuration / (float)targetDuration.longValue())) {
                txt = this.makeRed(txt);
            }
            return txt;
        }
        return this.makeRed("N/A");
    }

    public String getTcp_avg_throughput() {
        HttpSessionReader sourceSessionReader;
        Double throughput;
        Double throughput2;
        String unavailable = "N/A";
        if (this.httpDestinationSessionReader != null && (throughput2 = this.httpDestinationSessionReader.getRxThroughput(this.dataRateUnit)) != null) {
            int decimals = ByteBlowerPreferences.getNumberOfDecimals();
            return String.format("%." + decimals + "f", throughput2);
        }
        if (this.httpSourceSession != null && (throughput = (sourceSessionReader = EntityReaderFactory.create((HttpSession)this.httpSourceSession)).getTxThroughput(this.dataRateUnit)) != null) {
            int decimals = ByteBlowerPreferences.getNumberOfDecimals();
            return String.format("%." + decimals + "f (Tx)", throughput);
        }
        return "N/A";
    }

    public String getTcp_status() {
        HttpFlowInstance instance = (HttpFlowInstance)this.httpFlowReader.getEntity();
        return instance.getRequestStatusString();
    }

    public String getTcp_congestion_avoidance() {
        if (this.httpSourceSession == null || this.httpSourceSession.getTcpSession() == null) {
            return new String();
        }
        Object algorithm = this.httpSourceSession.getTcpSession().getCongestionAvoidanceAlgorithm() != null ? this.httpSourceSession.getTcpSession().getCongestionAvoidanceAlgorithm() : (this.httpDestinationSession != null && this.httpDestinationSession.getTcpSession() != null ? this.httpDestinationSession.getTcpSession().getCongestionAvoidanceAlgorithm() : null);
        if (algorithm != null) {
            return algorithm.toString();
        }
        return new String();
    }

    public Long getTcp_retransmission_count() {
        if (this.retransmit == null) {
            return 0L;
        }
        return this.retransmit.getTotalRetransmissions();
    }

    public Double getTcp_ttfb() {
        if (this.ttfb == null) {
            return null;
        }
        return LatencyUnit.convert((Long)this.ttfb, (LatencyUnit)LatencyUnit.NANOSECONDS, (LatencyUnit)this.latencyUnit);
    }

    public Double getTcp_rtt_average() {
        if (this.cumulative == null) {
            return null;
        }
        Long rttMax = this.cumulative.getRoundTripTimeCurrent();
        return LatencyUnit.convert((Long)rttMax, (LatencyUnit)LatencyUnit.NANOSECONDS, (LatencyUnit)this.latencyUnit);
    }

    public Double getTcp_rtt_maximum() {
        if (this.cumulative == null) {
            return null;
        }
        Long rttMax = this.cumulative.getRoundTripTimeMaximum();
        return LatencyUnit.convert((Long)rttMax, (LatencyUnit)LatencyUnit.NANOSECONDS, (LatencyUnit)this.latencyUnit);
    }

    public Double getTcp_rtt_minimum() {
        if (this.cumulative == null) {
            return null;
        }
        Long rttMin = this.cumulative.getRoundTripTimeMinimum();
        return LatencyUnit.convert((Long)rttMin, (LatencyUnit)LatencyUnit.NANOSECONDS, (LatencyUnit)this.latencyUnit);
    }
}

