/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports.beans;

import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.AbstractBean;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowTemplateFrame;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFrame;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFrameSizeFixed;
import com.excentis.products.byteblower.results.testdata.data.entities.ThroughputFlowResult;
import com.excentis.products.byteblower.results.testdata.data.entities.ThroughputFlowTest;
import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import com.excentis.products.byteblower.results.testdata.data.utils.EthernetThroughputType;
import com.excentis.products.byteblower.results.testdata.data.utils.ThroughputReader;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import java.util.Comparator;

public class ThroughputTestTableBean
extends AbstractBean {
    private long packetSize;
    private final String flowName;
    private final String sourceName;
    private final String destinationName;
    private double acceptableLoss;
    private double frameRate;
    private double byteRate;
    private double wireRate;
    private long duration;

    public ThroughputTestTableBean(ThroughputFlowTest test, ReportPreferencesInterface preferences) {
        super(preferences);
        for (FbFlowTemplateFrame templateFrames : test.getFlowTemplate().getFrames()) {
            FbFrame frame = templateFrames.getFrame();
            if (!(frame instanceof FbFrameSizeFixed)) continue;
            this.packetSize = ((FbFrameSizeFixed)frame).getSize().intValue();
        }
        this.acceptableLoss = test.getAcceptableLoss();
        this.sourceName = test.getSource().getName();
        this.destinationName = test.getDestination().getName();
        this.flowName = test.getName();
        this.duration = test.getIterationSize();
        double txFrameRate = 0.0;
        double difference = 1.0;
        for (ThroughputFlowResult result : test.getResults()) {
            if (!result.success()) continue;
            this.byteRate = Math.max(result.rxByteRate(this.throughputType), this.byteRate);
            this.wireRate = Math.max(result.rxByteRate(EthernetThroughputType.FRAME_FULL_LAYER1_INCL_IFG), this.wireRate);
            this.frameRate = Math.max(result.rxFrameRate(), this.frameRate);
            txFrameRate = Math.max(result.txFrameRate(), txFrameRate);
        }
        for (ThroughputFlowResult result : test.getResults()) {
            if (result.txFrameRate() == txFrameRate) continue;
            difference = Math.min(difference, Math.abs(txFrameRate - result.txFrameRate()) / txFrameRate);
        }
        this.byteRate = ThroughputReader.convertThroughput((Double)this.byteRate, (DataRateUnit)DataRateUnit.BYTE_PER_SECOND, (DataRateUnit)this.dataRateUnit);
        this.wireRate = ThroughputReader.convertThroughput((Double)this.wireRate, (DataRateUnit)DataRateUnit.BYTE_PER_SECOND, (DataRateUnit)this.dataRateUnit);
    }

    public long getPacketSize() {
        return this.packetSize;
    }

    public String getTest_flow() {
        if (this.frameRate == 0.0) {
            return this.makeRed(this.flowName);
        }
        return this.flowName;
    }

    public String getSource() {
        return this.sourceName;
    }

    public String getDuration() {
        return HighResolutionCalendarParser.getRelativeTime((long)this.duration);
    }

    public String getDestination() {
        return this.destinationName;
    }

    public String getFrameRate() {
        String formatted = this.throughputPatternParameter.format(this.frameRate);
        return this.colouring(formatted);
    }

    public String getBitRate() {
        String formatted = this.throughputPatternParameter.format(this.byteRate);
        return this.colouring(formatted);
    }

    public String getWiredRate() {
        String formatted = this.throughputPatternParameter.format(this.wireRate);
        return this.colouring(formatted);
    }

    public String getAcceptableLoss() {
        return this.throughputPatternParameter.format(this.acceptableLoss * 100.0);
    }

    private String colouring(String base) {
        if (this.frameRate == 0.0) {
            return this.makeRed(base);
        }
        return base;
    }

    public static class SortOnPacketSize
    implements Comparator<ThroughputTestTableBean> {
        @Override
        public int compare(ThroughputTestTableBean o1, ThroughputTestTableBean o2) {
            return Long.compare(o1.packetSize, o2.packetSize);
        }
    }
}

