/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports.generator;

import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.jasper.GenerateReport;
import com.excentis.products.byteblower.report.generator.jasper.datasource.ByteBlowerReportDataSource;
import com.excentis.products.byteblower.report.generator.jasper.subreports.GenerateBeanCollectionSubReport;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.ResultsOverTimeChartBean;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.AbstractFlowInstanceReader;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class GenerateResultsOverTimeSubReports<FlowType extends FlowInstance>
extends GenerateBeanCollectionSubReport {
    private static Map<TestDataReference, Long> firstOverallTimeNs = new HashMap<TestDataReference, Long>();
    private static Map<TestDataReference, Long> lastOverallTimeNs = new HashMap<TestDataReference, Long>();
    protected Class<FlowType> flowType;

    protected GenerateResultsOverTimeSubReports(GenerateReport<GenerateReportListener> parentAction, ReportItemWidgetEntity widget, ReportGeneration reportGeneration, Class<FlowType> flowType) {
        super(parentAction, widget, reportGeneration, (GenerateReportListener)parentAction.getListener());
        this.flowType = flowType;
    }

    @Override
    protected void fillBeans() {
        Scenario scenario = this.getScenario();
        FlowInstanceManager manager = this.getFlowInstanceManager();
        List flowInstances = manager.getAllFlowsOfType(scenario, this.flowType);
        for (FlowInstance flowInstance : flowInstances) {
            AbstractFlowInstanceReader flowInstanceReader = new AbstractFlowInstanceReader(flowInstance);
            if (!flowInstanceReader.isConfigured()) continue;
            List<ByteBlowerReportDataSource> pagingQueryDatasources = this.hasMultipleChartsPerFlow() ? this.createPagingQueries(flowInstance) : this.createQueryList(flowInstance);
            for (ByteBlowerReportDataSource datasource : pagingQueryDatasources) {
                if (datasource.isEmpty()) continue;
                TestDataReference testDataReference = this.getTestDataReference();
                ResultsOverTimeChartBean bean = new ResultsOverTimeChartBean(testDataReference, flowInstance, datasource);
                this.beans.add(bean);
            }
        }
    }

    protected boolean hasMultipleChartsPerFlow() {
        return false;
    }

    protected ArrayList<ByteBlowerReportDataSource> createPagingQueries(FlowType flowInstance) {
        return null;
    }

    protected abstract ByteBlowerReportDataSource createPagingQuery(FlowType var1);

    private List<ByteBlowerReportDataSource> createQueryList(FlowType flowInstance) {
        ArrayList<ByteBlowerReportDataSource> sources = new ArrayList<ByteBlowerReportDataSource>();
        ByteBlowerReportDataSource query = this.createPagingQuery(flowInstance);
        sources.add(query);
        return sources;
    }

    @Override
    protected boolean hasSubReports() {
        return true;
    }

    @Override
    public ReportItemWidgetEntity getWidget() {
        return this.widget;
    }

    protected abstract ReportItemWidgetEntity createSubReportEntity(ResultsOverTimeChartBean<?> var1);

    protected FlowInstanceManager getFlowInstanceManager() {
        return new FlowInstanceManager(this.getPersistenceController());
    }

    static Long getEarliestOverallTimeNs(GenerateResultsOverTimeSubReports<?> generator) {
        TestDataReference testDataReference = generator.getTestDataReference();
        if (firstOverallTimeNs.containsKey(testDataReference)) {
            return firstOverallTimeNs.get(testDataReference);
        }
        EntityManager entityManager = generator.getEntityManager();
        long min = MINMAX.MIN.DEFAULT;
        min = Math.min(min, GenerateResultsOverTimeSubReports.getMinMaxSnapshotTime(entityManager, "FbTriggerSnapshot", MINMAX.MIN));
        min = Math.min(min, GenerateResultsOverTimeSubReports.getMinMaxSnapshotTime(entityManager, "FbLatencySnapshot", MINMAX.MIN));
        min = Math.min(min, GenerateResultsOverTimeSubReports.getMinMaxSnapshotTime(entityManager, "FbOutOfSequenceSnapshot", MINMAX.MIN));
        min = Math.min(min, GenerateResultsOverTimeSubReports.getMinMaxSnapshotTime(entityManager, "HttpSessionSnapshot", MINMAX.MIN));
        firstOverallTimeNs.put(testDataReference, min);
        return min;
    }

    static Long getLastOverallTimeNs(GenerateResultsOverTimeSubReports<?> generator) {
        TestDataReference testDataReference = generator.getTestDataReference();
        if (lastOverallTimeNs.containsKey(testDataReference)) {
            return lastOverallTimeNs.get(testDataReference);
        }
        EntityManager entityManager = generator.getEntityManager();
        Long max = MINMAX.MAX.DEFAULT;
        max = Math.max(max, GenerateResultsOverTimeSubReports.getMinMaxSnapshotTime(entityManager, "FbTriggerSnapshot", MINMAX.MAX));
        max = Math.max(max, GenerateResultsOverTimeSubReports.getMinMaxSnapshotTime(entityManager, "FbLatencySnapshot", MINMAX.MAX));
        max = Math.max(max, GenerateResultsOverTimeSubReports.getMinMaxSnapshotTime(entityManager, "FbOutOfSequenceSnapshot", MINMAX.MAX));
        max = Math.max(max, GenerateResultsOverTimeSubReports.getMinMaxSnapshotTime(entityManager, "HttpSessionSnapshot", MINMAX.MAX));
        lastOverallTimeNs.put(testDataReference, max);
        return max;
    }

    private static Long getMinMaxSnapshotTime(EntityManager entityManager, String table, MINMAX function) {
        return GenerateResultsOverTimeSubReports.getMinMax(entityManager, table, function, "snapshotTime");
    }

    private static long getMinMax(EntityManager entityManager, String table, MINMAX function, String field) {
        String sizeQueryString = "SELECT COUNT(s." + field + ") FROM " + table + " s";
        TypedQuery sizeQuery = entityManager.createQuery(sizeQueryString, Long.class);
        if ((Long)sizeQuery.getSingleResult() == 0L) {
            return function.DEFAULT;
        }
        String queryString = "SELECT " + (Object)((Object)function) + "(s." + field + ") FROM " + table + " s";
        TypedQuery query = entityManager.createQuery(queryString, Long.class);
        Long result = (Long)query.getSingleResult();
        return result;
    }

    public Long getEarliestOverallTimeNs() {
        return GenerateResultsOverTimeSubReports.getEarliestOverallTimeNs(this);
    }

    public Long getLastOverallTimeNs() {
        return GenerateResultsOverTimeSubReports.getLastOverallTimeNs(this);
    }

    public boolean needsTimeZoneOffset() {
        return true;
    }

    private static enum MINMAX {
        MIN(Long.MAX_VALUE),
        MAX(0L);

        public final long DEFAULT;

        private MINMAX(long defaultValue) {
            this.DEFAULT = defaultValue;
        }
    }
}

