/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports.generator.chart;

import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.jasper.GenerateReport;
import com.excentis.products.byteblower.report.generator.jasper.datasource.AggregateRxHttpThroughputRotChartDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.ByteBlowerReportDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.PagingQueryDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.ThroughputSnapshot;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.ResultsOverTimeChartBean;
import com.excentis.products.byteblower.report.generator.jasper.subreports.entities.ResultsOverTimeChartEntity;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeCharts;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.Flow;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.enums.HttpRequestMethod;
import jakarta.persistence.EntityManager;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.Cursor;

public class GenerateAggregateRxThroughputResultsOverTimeCharts
extends GenerateResultsOverTimeCharts<HttpFlowInstance> {
    private static final Logger LOGGER = Logger.getGlobal();
    private Map<Long, String> flowNames = new HashMap<Long, String>();

    public GenerateAggregateRxThroughputResultsOverTimeCharts(GenerateReport<GenerateReportListener> parentAction, ReportItemWidgetEntity widget, ReportGeneration reportGeneration, Class<HttpFlowInstance> flowType) {
        super(parentAction, widget, reportGeneration, flowType);
    }

    private Set<Port> byteblowerPortsInUse() {
        FlowInstanceManager flows = new FlowInstanceManager(this.getPersistenceController());
        List httpFlows = flows.getAllFlowsOfTypeIncludingParents(this.getScenario(), HttpFlowInstance.class);
        HashMap<Port, ArrayList<HttpSession>> portsToSum = new HashMap<Port, ArrayList<HttpSession>>();
        for (HttpFlowInstance httpFlowInstance : httpFlows) {
            HttpSession serverSession;
            ArrayList<HttpSession> sessions;
            Flow flow = httpFlowInstance.getFlow();
            String flowName = flow.getName();
            HttpRequestMethod method = httpFlowInstance.getRequestMethod();
            String acksPostfix = "(ACKS)";
            HttpSession clientSession = httpFlowInstance.getClientHttpSession();
            if (clientSession != null) {
                String post = method == HttpRequestMethod.PUT ? acksPostfix : "";
                this.flowNames.put(clientSession.getId(), String.valueOf(flowName) + post);
                Port clientPort = clientSession.getHttpApplication().getPort();
                if (httpFlowInstance.getParent() == null) {
                    sessions = (ArrayList<HttpSession>)portsToSum.get(clientPort);
                    if (sessions == null) {
                        sessions = new ArrayList<HttpSession>();
                        portsToSum.put(clientPort, sessions);
                    }
                    sessions.add(clientSession);
                }
            }
            if ((serverSession = httpFlowInstance.getServerHttpSession()) == null) continue;
            String post = method == HttpRequestMethod.GET ? acksPostfix : "";
            this.flowNames.put(serverSession.getId(), String.valueOf(flowName) + post);
            Port serverPort = serverSession.getHttpApplication().getPort();
            sessions = (List)portsToSum.get(serverPort);
            if (httpFlowInstance.getParent() != null) continue;
            if (sessions == null) {
                sessions = new ArrayList();
                portsToSum.put(serverPort, sessions);
            }
            sessions.add(serverSession);
        }
        return portsToSum.keySet();
    }

    @Override
    protected void fillBeans() {
        TestDataReference reference = this.getTestDataReference();
        Set<Port> portsToSum = this.byteblowerPortsInUse();
        long startTime = this.getEarliestOverallTimeNs();
        for (Port port : portsToSum) {
            Map<Long, Iterator<ThroughputSnapshot>> iteratorMap;
            Set<Long> ids;
            long portnumber = port.getId();
            String portName = port.getName();
            TestDataPersistenceController testData = this.getPersistenceController();
            AggregateRxHttpThroughputRotChartDataSource source = this.createSource(portName);
            TXSnaps snaps = new TXSnaps(testData, portnumber, "rx_count_total", startTime);
            if (snaps.isEmpty() || (ids = (iteratorMap = snaps.iterators()).keySet()).size() < 2) continue;
            List<Long> sortedIds = this.sortToScenario(ids);
            for (Long httpSessionID : sortedIds) {
                Iterator<ThroughputSnapshot> it = iteratorMap.get(httpSessionID);
                String flowname = this.getFlowName(httpSessionID);
                source.addSeries(flowname, it);
            }
            ResultsOverTimeChartBean bean = new ResultsOverTimeChartBean(reference, port, (ByteBlowerReportDataSource)source);
            this.beans.add(bean);
        }
    }

    protected AggregateRxHttpThroughputRotChartDataSource createSource(String portName) {
        AggregateRxHttpThroughputRotChartDataSource source = new AggregateRxHttpThroughputRotChartDataSource(this, portName);
        return source;
    }

    private List<Long> sortToScenario(Set<Long> ids) {
        Scenario gg = this.getScenario();
        class NameIdPair
        implements Comparable<NameIdPair> {
            private long id;
            int scenarioPosition;

            NameIdPair() {
            }

            @Override
            public int compareTo(NameIdPair o) {
                return this.scenarioPosition - o.scenarioPosition;
            }
        }
        ArrayList<NameIdPair> toSort = new ArrayList<NameIdPair>();
        HashMap<String, Integer> positions = new HashMap<String, Integer>();
        for (FlowInstance flow : gg.getFlowInstances()) {
            String name = flow.getFlow().getName();
            int position = flow.getScenarioPosition();
            positions.put(name, position);
        }
        for (Long id : ids) {
            NameIdPair pair = new NameIdPair();
            pair.id = id;
            Integer position = (Integer)positions.get(this.getFlowName(id));
            if (position == null) {
                position = Integer.MAX_VALUE;
            }
            pair.scenarioPosition = position;
            toSort.add(pair);
        }
        Collections.sort(toSort);
        ArrayList<Long> result = new ArrayList<Long>();
        for (NameIdPair pair : toSort) {
            result.add(pair.id);
        }
        return result;
    }

    private String getFlowName(Long sessionID) {
        if (this.flowNames.containsKey(sessionID)) {
            return this.flowNames.get(sessionID);
        }
        System.out.format("GenerateAggregateRxThroughputResultsOverTimeCharts:: NULL flow name, searched for %d\n", sessionID);
        return "";
    }

    @Override
    protected ResultsOverTimeChartEntity createChartEntity(ResultsOverTimeChartBean<?> bean) {
        ResultsOverTimeChartEntity entity = new ResultsOverTimeChartEntity(bean);
        entity.setReportDesignFile("results_over_time_aggregate");
        return entity;
    }

    protected PagingQueryDataSource<?> createPagingQuery(HttpFlowInstance flowInstance) {
        return null;
    }

    private static class TXSnaps {
        private static final String QUERYALIVE = "SELECT r.tcp_session_id as session, SYN_RX.TIME_LAST_SYN_RECEIVED as start, RX.RX_TIMESTAMP_LAST is NOT NULL as didEnd, RX.RX_TIMESTAMP_LAST as end FROM TCP_SESSION_CUMULATIVE_SNAPSHOT as CUMUL, (TCP_SESSION_SNAPSHOT as r LEFT OUTER JOIN TCP_SESSION_SNAPSHOT_RX_COUNTERS  as RX ON r.id = rx.snapshot_id) LEFT JOIN HTTP_SESSION as htt on r.TCP_SESSION_ID= htt.TCP_SESSION_ID,TCP_SESSION_SNAPSHOT_SYN_RECEIVED as SYN_RX, APPLICATION as app WHERE r.id = cumul.snapshot_id AND r.id=rx.snapshot_id AND r.id = SYN_RX.snapshot_id AND r.TCP_SESSION_ID= htt.TCP_SESSION_ID AND app.id = htt.APPLICATION_HTTP_ID AND app.port_id = ? ORDER BY SYN_RX.TIME_LAST_SYN_RECEIVED ";
        private static final String QUERYSNAPSFORMAT = "SELECT rr.TCP_SESSION_ID , rr.SNAPSHOT_TIME , rr.snAPSHOT_DURATION , IFNULL(%s , 0L) FROM  TCP_SESSION_SNAPSHOT as rr LEFT OUTER JOIN TCP_SESSION_CUMULATIVE_SNAPSHOT as cumul ON rr.iD  = cumul.SNAPSHOT_ID, TCP_SESSION_SNAPSHOT as gr LEFT OUTER JOIN TCP_SESSION_SNAPSHOT_RX_COUNTERS as rx ON gr.id = rx.snapshot_id WHERE gr.id = rr.id  AND cumul.id IS NULL ORDER BY rr.SNAPSHOT_TIME ASC";
        private final String querySnaps;
        private final long graphStartTime;
        private final EntityManager em;
        private HashMap<Long, Long> tcpStart = new HashMap();
        private HashMap<Long, Long> tcpEnd = new HashMap();
        private HashMap<Long, WeakReference<List<Sample>>> values = new HashMap();

        public TXSnaps(TestDataPersistenceController testData, long portNum, String column, long startTime) {
            this.graphStartTime = startTime;
            this.em = testData.createEntityManager();
            this.em.setProperty("eclipselink.jdbc.exclusive-connection.mode", (Object)"Transactional");
            this.querySnaps = String.format(QUERYSNAPSFORMAT, column);
            this.fillTCPLivetime(this.em, portNum);
        }

        public boolean isEmpty() {
            this.populateAll(Long.MIN_VALUE);
            for (Iterator<ThroughputSnapshot> it : this.iterators().values()) {
                if (!it.hasNext()) continue;
                return false;
            }
            return true;
        }

        private void fillTCPLivetime(EntityManager em, long portNumber) {
            JpaQuery aliveSessionsQuery = (JpaQuery)em.createNativeQuery(QUERYALIVE);
            aliveSessionsQuery.setParameter(1, (Object)portNumber);
            aliveSessionsQuery.setHint("eclipselink.cursor.scrollable.result-set-type", (Object)"ForwardOnly").setHint("eclipselink.cursor.scrollable", (Object)true);
            Cursor sessionCursor = aliveSessionsQuery.getResultCursor();
            ResultSet aliveSessionsResult = sessionCursor.getResultSet();
            try {
                while (aliveSessionsResult.next()) {
                    long tcpIdent = aliveSessionsResult.getLong(1);
                    long start = aliveSessionsResult.getLong(2);
                    boolean tcpDidEnd = aliveSessionsResult.getBoolean(3);
                    long end = aliveSessionsResult.getLong(4);
                    this.tcpStart.put(tcpIdent, start);
                    if (tcpDidEnd) {
                        this.tcpEnd.put(tcpIdent, end);
                        continue;
                    }
                    this.tcpEnd.put(tcpIdent, Long.MAX_VALUE);
                }
                aliveSessionsResult.close();
                sessionCursor.close();
            }
            catch (SQLException sql) {
                LOGGER.log(Level.WARNING, "sql error at" + System.nanoTime(), sql);
            }
        }

        private List<Sample> populateAll(long sessionID) {
            WeakReference<List<Sample>> ref;
            List result = new ArrayList();
            if (this.values.containsKey(sessionID) && (result = (List)(ref = this.values.get(sessionID)).get()) != null) {
                return result;
            }
            HashMap<Long, ArrayList<Sample>> valuesInCalculation = new HashMap<Long, ArrayList<Sample>>();
            JpaQuery aliveSnapshotsQuery = (JpaQuery)this.em.createNativeQuery(this.querySnaps);
            aliveSnapshotsQuery.setHint("eclipselink.cursor.scrollable.result-set-type", (Object)"ForwardOnly").setHint("eclipselink.cursor.scrollable", (Object)true);
            Cursor snapshotCursor = aliveSnapshotsQuery.getResultCursor();
            ResultSet aliveSnapshotsResult = snapshotCursor.getResultSet();
            try {
                while (aliveSnapshotsResult.next()) {
                    long l = aliveSnapshotsResult.getLong(1);
                    long start = aliveSnapshotsResult.getLong(2);
                    long duration = aliveSnapshotsResult.getLong(3);
                    long value = aliveSnapshotsResult.getLong(4);
                    ArrayList<Sample> row = (ArrayList<Sample>)valuesInCalculation.get(l);
                    if (row == null) {
                        row = new ArrayList<Sample>();
                        valuesInCalculation.put(l, row);
                    }
                    row.add(new Sample(start, value));
                }
                snapshotCursor.close();
                for (List list : valuesInCalculation.values()) {
                    ((ArrayList)list).trimToSize();
                }
                result = (List)valuesInCalculation.get(sessionID);
                this.values.clear();
                for (Map.Entry entry : valuesInCalculation.entrySet()) {
                    this.values.put((Long)entry.getKey(), new WeakReference<List>((List)entry.getValue()));
                }
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.WARNING, "Not able to fetch next Snapshot", sQLException);
            }
            if (result == null) {
                return new ArrayList<Sample>();
            }
            return result;
        }

        public Map<Long, Iterator<ThroughputSnapshot>> iterators() {
            HashMap<Long, Iterator<ThroughputSnapshot>> result = new HashMap<Long, Iterator<ThroughputSnapshot>>();
            Iterator<Long> iterator = this.tcpStart.keySet().iterator();
            while (iterator.hasNext()) {
                long tcpSessionID;
                final long sessionID = tcpSessionID = iterator.next().longValue();
                Iterator<ThroughputSnapshot> it = new Iterator<ThroughputSnapshot>(){
                    int requestedCtr = 0;
                    int listCtr = 0;
                    long lastMoment = 0L;
                    boolean notYetStarted = true;
                    boolean finished = false;
                    SoftReference<List<Sample>> tcpRef;
                    {
                        this.tcpRef = new SoftReference<List<Sample>>(tXSnaps.populateAll(l));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public ThroughputSnapshot next() {
                        List<Sample> tcpVals = this.tcpRef.get();
                        if (tcpVals == null) {
                            tcpVals = this.populateAll(sessionID);
                            this.tcpRef = new SoftReference<List<Sample>>(tcpVals);
                        }
                        if (this.requestedCtr == 0) {
                            long startMoment;
                            ++this.requestedCtr;
                            this.lastMoment = startMoment = tcpStart.get(sessionID) - graphStartTime;
                            return new ThroughputSnapshot(0L, startMoment);
                        }
                        if (this.listCtr < tcpVals.size()) {
                            Sample p = tcpVals.get(this.listCtr);
                            long duration = 1000000000L;
                            long newMoment = p.time + duration - graphStartTime;
                            if (this.notYetStarted && newMoment - this.lastMoment > duration) {
                                long extraMoment;
                                this.lastMoment = extraMoment = newMoment - duration;
                                return new ThroughputSnapshot(0L, extraMoment);
                            }
                            this.notYetStarted = false;
                            ++this.listCtr;
                            this.lastMoment = newMoment;
                            return new ThroughputSnapshot(p.value, newMoment);
                        }
                        this.finished = true;
                        ++this.requestedCtr;
                        return new ThroughputSnapshot(0L, this.lastMoment + 1L);
                    }

                    @Override
                    public boolean hasNext() {
                        List<Sample> tcpVals = this.tcpRef.get();
                        if (tcpVals == null) {
                            tcpVals = this.populateAll(sessionID);
                            this.tcpRef = new SoftReference<List<Sample>>(tcpVals);
                        }
                        return !tcpVals.isEmpty() && tcpVals.size() + 2 > this.requestedCtr && !this.finished;
                    }
                };
                result.put(tcpSessionID, it);
            }
            return result;
        }

        private static final class Sample {
            final long time;
            final long value;

            public Sample(long time, long value) {
                this.time = time;
                this.value = value;
            }
        }
    }
}

