/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports.generator.chart;

import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.jasper.GenerateReport;
import com.excentis.products.byteblower.report.generator.jasper.datasource.ByteBlowerReportDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.FbLatencyRotDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.PagingQueryDataSource;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.ResultsOverTimeChartBean;
import com.excentis.products.byteblower.report.generator.jasper.subreports.entities.ResultsOverTimeChartEntity;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeCharts;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatency;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatencySnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbLatencyReader;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class GenerateFbLatencyResultsOverTimeCharts
extends GenerateResultsOverTimeCharts<FbFlowInstance> {
    public GenerateFbLatencyResultsOverTimeCharts(GenerateReport<GenerateReportListener> parentAction, ReportItemWidgetEntity widget, ReportGeneration reportGeneration, Class<FbFlowInstance> flowType) {
        super(parentAction, widget, reportGeneration, flowType);
    }

    @Override
    protected ResultsOverTimeChartEntity createChartEntity(ResultsOverTimeChartBean<?> bean) {
        ResultsOverTimeChartEntity entity = new ResultsOverTimeChartEntity(bean);
        entity.setReportDesignFile("results_over_time_chart_latency");
        return entity;
    }

    @Override
    protected boolean hasMultipleChartsPerFlow() {
        return true;
    }

    @Override
    protected ArrayList<ByteBlowerReportDataSource> createPagingQueries(FbFlowInstance flowInstance) {
        FbFlowInstanceReader reader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
        String flowName = reader.getName();
        String sourceName = reader.getSource().getPort().getName();
        Set destinations = reader.getDestinationsAndEavesdroppers();
        EntityManager entityManager = this.getEntityManager();
        ArrayList<ByteBlowerReportDataSource> destinationChartDataSources = new ArrayList<ByteBlowerReportDataSource>();
        for (FbDestination destination : destinations) {
            HashMap<String, TypedQuery<FbLatencySnapshot>> queryMap = new HashMap<String, TypedQuery<FbLatencySnapshot>>();
            String destinationName = destination.getPort().getName();
            FbLatency fbLatency = destination.getLatency();
            if (fbLatency == null) continue;
            FbLatencyReader fbLatencyReader = EntityReaderFactory.create((FbLatency)fbLatency);
            TypedQuery snapshotQuery = fbLatencyReader.getSnapshotsQuery(entityManager);
            queryMap.put(destinationName, snapshotQuery);
            destinationChartDataSources.add(new FbLatencyRotDataSource(entityManager, this, flowName, sourceName, destinationName, queryMap));
        }
        return destinationChartDataSources;
    }

    protected PagingQueryDataSource<?> createPagingQuery(FbFlowInstance flowInstance) {
        System.out.println("GenerateFbLatencyResultsOverTimeCharts::createPagingQuery should never be called");
        return null;
    }
}

