/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports.generator.chart;

import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.jasper.GenerateReport;
import com.excentis.products.byteblower.report.generator.jasper.datasource.FbThroughputRotChartDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.PagingQueryDataSource;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.ResultsOverTimeChartBean;
import com.excentis.products.byteblower.report.generator.jasper.subreports.entities.ResultsOverTimeChartEntity;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeCharts;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTrigger;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTriggerSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbTriggerReader;
import com.excentis.products.byteblower.results.testdata.data.utils.EthernetThroughputType;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.HashMap;
import java.util.Set;

public class GenerateFbThroughputResultsOverTimeCharts
extends GenerateResultsOverTimeCharts<FbFlowInstance> {
    public GenerateFbThroughputResultsOverTimeCharts(GenerateReport<GenerateReportListener> parentAction, ReportItemWidgetEntity widget, ReportGeneration reportGeneration, Class<FbFlowInstance> flowType) {
        super(parentAction, widget, reportGeneration, flowType);
    }

    @Override
    protected ResultsOverTimeChartEntity createChartEntity(ResultsOverTimeChartBean<?> bean) {
        return new ResultsOverTimeChartEntity("results_over_time_chart", bean);
    }

    protected PagingQueryDataSource<?> createPagingQuery(FbFlowInstance flowInstance) {
        FbFlowInstanceReader reader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
        String flowName = reader.getName();
        Set destinations = reader.getDestinationsAndEavesdroppers();
        EntityManager entityManager = this.getEntityManager();
        TypedQuery snapshotQuery = null;
        HashMap<String, TypedQuery<FbTriggerSnapshot>> queryMap = new HashMap<String, TypedQuery<FbTriggerSnapshot>>();
        for (FbDestination destination : destinations) {
            boolean hasData;
            String portName = destination.getPort().getName();
            FbTriggerReader fbTriggerReader = EntityReaderFactory.create((FbTrigger)destination.getTrigger());
            boolean bl = hasData = fbTriggerReader.getThroughputBitsPerSecond(EthernetThroughputType.FRAME_ONLY) != null;
            if (!hasData) continue;
            snapshotQuery = fbTriggerReader.getSnapshotsQuery(entityManager);
            queryMap.put(portName, (TypedQuery<FbTriggerSnapshot>)snapshotQuery);
        }
        return new FbThroughputRotChartDataSource(entityManager, this, flowName, queryMap);
    }
}

