/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports.generator.chart;

import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.jasper.GenerateReport;
import com.excentis.products.byteblower.report.generator.jasper.subreports.GenerateBeanCollectionSubReport;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.LatencyDistributionChartBean;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.LatencyDistributionChartDataBean;
import com.excentis.products.byteblower.report.generator.jasper.subreports.entities.LatencyCcdfChartEntity;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatencyDistribution;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.utils.LatencyUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.design.JRDesignBand;

public class GenerateLatencyCcdfCharts
extends GenerateBeanCollectionSubReport {
    private String designFileName;

    public GenerateLatencyCcdfCharts(GenerateReport<GenerateReportListener> parentReport, ReportItemWidgetEntity widget, ReportGeneration reportGeneration, String designFileName) {
        super(parentReport, widget, reportGeneration, (GenerateReportListener)parentReport.getListener());
        this.designFileName = designFileName;
    }

    private Collection<LatencyDistributionChartDataBean> getBarBeans(String flowName, FbDestination destination) {
        ArrayList<LatencyDistributionChartDataBean> dataBeans = new ArrayList<LatencyDistributionChartDataBean>();
        String destinationPortName = destination.getPort().getName();
        FbLatencyDistribution fbLatencyDistribution = destination.getLatency().getDistribution();
        if (fbLatencyDistribution != null) {
            LatencyDistributionChartDataBean last;
            LatencyDistributionChartDataBean first;
            Map distribution = fbLatencyDistribution.getEntries();
            Long rangeMinNs = fbLatencyDistribution.getLatencyRangeMinimum();
            Long bucketDurationNs = fbLatencyDistribution.getBucketWidth();
            LatencyUnit unit = this.getReportPreferences().getLatencyUnit().getRawUnit();
            Double rangeMin = LatencyUnit.convert((Long)rangeMinNs, (LatencyUnit)LatencyUnit.NANOSECONDS, (LatencyUnit)unit);
            Long packetCountBelowMin = fbLatencyDistribution.getPacketCountBelowMinimum();
            Long packetCountAboveMax = fbLatencyDistribution.getPacketCountAboveMaximum();
            long totalNofSampledPackets = packetCountBelowMin + packetCountAboveMax;
            for (Map.Entry chartValuePoint : distribution.entrySet()) {
                Long xvalueLong = (Long)chartValuePoint.getKey();
                Double xvalueDouble = xvalueLong + bucketDurationNs;
                xvalueDouble = LatencyUnit.convert((Double)xvalueDouble, (LatencyUnit)LatencyUnit.NANOSECONDS, (LatencyUnit)unit);
                Long nofPacketsInBucket = (Long)chartValuePoint.getValue();
                totalNofSampledPackets += nofPacketsInBucket.longValue();
                LatencyDistributionChartDataBean dataBean = new LatencyDistributionChartDataBean(flowName, destinationPortName, xvalueDouble, nofPacketsInBucket);
                dataBeans.add(dataBean);
            }
            Collections.sort(dataBeans);
            while ((first = (LatencyDistributionChartDataBean)dataBeans.get(0)).getY_value() == 0L) {
                dataBeans.remove(0);
                if (dataBeans.size() > 0) continue;
            }
            int lastIndex = -1;
            while (dataBeans.size() != 0 && (last = (LatencyDistributionChartDataBean)dataBeans.get(lastIndex = dataBeans.size() - 1)).getY_value() == 0L) {
                dataBeans.remove(lastIndex);
                if (lastIndex >= 0) continue;
            }
            dataBeans.add(0, new LatencyDistributionChartDataBean(flowName, destinationPortName, rangeMin, packetCountBelowMin));
            dataBeans.add(new LatencyDistributionChartDataBean(flowName, destinationPortName, null, totalNofSampledPackets));
            dataBeans.add(new LatencyDistributionChartDataBean(flowName, destinationPortName, null, packetCountAboveMax));
            Long totalRxPacketCount = destination.getTrigger().getPacketCount();
            dataBeans.add(new LatencyDistributionChartDataBean(flowName, destinationPortName, null, totalRxPacketCount));
        }
        LatencyDistributionChartDataBean first = (LatencyDistributionChartDataBean)dataBeans.get(0);
        ArrayList<LatencyDistributionChartDataBean> duplicateFirstBean = new ArrayList<LatencyDistributionChartDataBean>();
        duplicateFirstBean.add(first);
        duplicateFirstBean.addAll(dataBeans);
        return duplicateFirstBean;
    }

    @Override
    protected void fillBeans() {
        Scenario scenario = this.getScenario();
        FlowInstanceManager manager = this.getFlowInstanceManager();
        List flowInstances = manager.getAllFlowsOfType(scenario, FbFlowInstance.class);
        for (FbFlowInstance flowInstance : flowInstances) {
            FbFlowInstanceReader reader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
            if (!reader.isConfigured()) continue;
            Set destinations = reader.getDestinationsAndEavesdroppers();
            String flowName = reader.getName();
            for (FbDestination destination : destinations) {
                Collection<LatencyDistributionChartDataBean> barBeans;
                FbLatencyDistribution fbLatencyDistribution;
                if (destination.getLatency() == null || (fbLatencyDistribution = destination.getLatency().getDistribution()) == null || (barBeans = this.getBarBeans(flowName, destination)).isEmpty()) continue;
                LatencyDistributionChartBean bean = new LatencyDistributionChartBean(this.getTestDataReference(), barBeans);
                this.beans.add(bean);
            }
        }
    }

    @Override
    protected boolean hasSubReports() {
        return true;
    }

    @Override
    protected void generateSubReports() {
        Collection<?> beans = this.getBeans();
        int posY = this.jasperDesign.getTitle().getHeight();
        int width = this.jasperDesign.getPageWidth();
        JRDesignBand designBand = (JRDesignBand)this.jasperDesign.getTitle();
        boolean onlyTheFirst = true;
        for (LatencyDistributionChartBean bean : beans) {
            LatencyCcdfChartEntity entity = onlyTheFirst ? new LatencyCcdfChartEntity(this.designFileName, bean) : new LatencyCcdfChartEntity("latency_ccdf_highcharts_invisible", bean);
            onlyTheFirst = false;
            boolean succes = this.insertSubReport(designBand, entity, 0, width, posY);
            if (!succes) break;
            if (!onlyTheFirst) continue;
            posY = designBand.getHeight();
        }
    }

    private FlowInstanceManager getFlowInstanceManager() {
        return new FlowInstanceManager(this.getPersistenceController());
    }
}

