/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports.generator.chart;

import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.jasper.GenerateReport;
import com.excentis.products.byteblower.report.generator.jasper.subreports.GenerateBeanCollectionSubReport;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.EndBarChartDataBean;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.LatencyDistributionChartBean;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.LatencyDistributionChartDataBean;
import com.excentis.products.byteblower.report.generator.jasper.subreports.entities.LatencyDistributionChartEntity;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatencyDistribution;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.utils.LatencyUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.design.JRDesignBand;

public class GenerateLatencyDistributionCharts
extends GenerateBeanCollectionSubReport {
    private String designFileName;
    private boolean fixedNanoUnits = false;

    public GenerateLatencyDistributionCharts(GenerateReport<GenerateReportListener> parentReport, ReportItemWidgetEntity widget, ReportGeneration reportGeneration, String designFileName) {
        super(parentReport, widget, reportGeneration, (GenerateReportListener)parentReport.getListener());
        this.designFileName = designFileName;
    }

    GenerateLatencyDistributionCharts forceNarrowBins(boolean enableNanos) {
        this.fixedNanoUnits = enableNanos;
        return this;
    }

    private Collection<LatencyDistributionChartDataBean> getBarBeans(String flowName, FbDestination destination) {
        ArrayList<LatencyDistributionChartDataBean> dataBeans = new ArrayList<LatencyDistributionChartDataBean>();
        String destinationPortName = destination.getPort().getName();
        FbLatencyDistribution fbLatencyDistribution = destination.getLatency().getDistribution();
        if (fbLatencyDistribution != null) {
            Map distribution = fbLatencyDistribution.getEntries();
            Long maxNs = fbLatencyDistribution.getLatencyRangeMaximum();
            Long minNs = fbLatencyDistribution.getLatencyRangeMinimum();
            Long bucketDuration = fbLatencyDistribution.getBucketWidth();
            long maxBucketCount = Long.MIN_VALUE;
            long packetCountAboveMax = fbLatencyDistribution.getPacketCountAboveMaximum();
            long packetCountBelowMin = fbLatencyDistribution.getPacketCountBelowMinimum();
            LatencyUnit unit = this.fixedNanoUnits ? LatencyUnit.NANOSECONDS : this.getReportPreferences().getLatencyUnit().getRawUnit();
            for (Map.Entry chartValuePoint : distribution.entrySet()) {
                Long xvalueLong = (Long)chartValuePoint.getKey();
                if (xvalueLong < minNs || xvalueLong > maxNs + 2L * bucketDuration) continue;
                Double xvalueDouble = new Double(xvalueLong.longValue());
                xvalueDouble = LatencyUnit.convert((Double)xvalueDouble, (LatencyUnit)LatencyUnit.NANOSECONDS, (LatencyUnit)unit);
                Long packetCount = (Long)chartValuePoint.getValue();
                maxBucketCount = Math.max(packetCount, maxBucketCount);
                LatencyDistributionChartDataBean dataBean = new LatencyDistributionChartDataBean(flowName, destinationPortName, xvalueDouble, packetCount);
                dataBeans.add(dataBean);
            }
            Collections.sort(dataBeans);
            String distributionWarning = new String();
            if (packetCountBelowMin > 0L || packetCountAboveMax > 0L) {
                long totalCount = destination.getTrigger().getPacketCount();
                double graphBoundaryDistance = 50.0 * (double)bucketDuration.longValue();
                if (packetCountBelowMin > 0L) {
                    EndBarChartDataBean underBean = new EndBarChartDataBean(flowName, destinationPortName, minNs, (double)minNs.longValue() - graphBoundaryDistance, packetCountBelowMin, "<");
                    underBean.setHeight(maxBucketCount);
                    distributionWarning = this.appendBoundaryWarning(distributionWarning, "under", underBean, packetCountBelowMin, totalCount);
                }
                if (packetCountAboveMax > 0L) {
                    EndBarChartDataBean overBean = new EndBarChartDataBean(flowName, destinationPortName, maxNs, (double)maxNs.longValue() + graphBoundaryDistance, packetCountAboveMax, "\u2265");
                    overBean.setHeight(maxBucketCount);
                    distributionWarning = this.appendBoundaryWarning(distributionWarning, "over", overBean, packetCountAboveMax, totalCount);
                }
            }
            if (!distributionWarning.isEmpty()) {
                distributionWarning = "<b>Warning: " + distributionWarning + " </b>";
            }
            for (LatencyDistributionChartDataBean bean : dataBeans) {
                bean.setData_type("Latency");
                bean.setData_unit(LatencyUnit.NANOSECONDS.toString());
                bean.setScaleWarning(distributionWarning);
                bean.setHeight(maxBucketCount);
            }
        }
        LatencyDistributionChartDataBean first = (LatencyDistributionChartDataBean)dataBeans.get(0);
        ArrayList<LatencyDistributionChartDataBean> duplicateFirstBean = new ArrayList<LatencyDistributionChartDataBean>();
        duplicateFirstBean.add(first);
        duplicateFirstBean.addAll(dataBeans);
        return duplicateFirstBean;
    }

    private String appendBoundaryWarning(String previous, String direction, EndBarChartDataBean bean, long packets, long totalPacketCount) {
        if (!previous.isEmpty()) {
            previous = String.valueOf(previous) + ", ";
        }
        previous = String.valueOf(previous) + String.format("%d (%.2f %%) packets %s %s", packets, 100.0 * (double)packets / (double)totalPacketCount, direction, bean.cuttoff());
        return previous;
    }

    @Override
    protected void fillBeans() {
        Scenario scenario = this.getScenario();
        FlowInstanceManager manager = this.getFlowInstanceManager();
        List flowInstances = manager.getAllFlowsOfType(scenario, FbFlowInstance.class);
        for (FbFlowInstance flowInstance : flowInstances) {
            FbFlowInstanceReader reader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
            if (!reader.isConfigured()) continue;
            Set destinations = reader.getDestinationsAndEavesdroppers();
            String flowName = reader.getName();
            for (FbDestination destination : destinations) {
                Collection<LatencyDistributionChartDataBean> barBeans;
                FbLatencyDistribution fbLatencyDistribution;
                if (destination.getLatency() == null || (fbLatencyDistribution = destination.getLatency().getDistribution()) == null || (barBeans = this.getBarBeans(flowName, destination)).isEmpty()) continue;
                LatencyDistributionChartBean bean = new LatencyDistributionChartBean(this.getTestDataReference(), barBeans);
                this.beans.add(bean);
            }
        }
    }

    @Override
    protected boolean hasSubReports() {
        return true;
    }

    @Override
    protected void generateSubReports() {
        Collection<?> beans = this.getBeans();
        int posY = this.jasperDesign.getTitle().getHeight();
        int width = this.jasperDesign.getPageWidth();
        JRDesignBand designBand = (JRDesignBand)this.jasperDesign.getTitle();
        for (LatencyDistributionChartBean bean : beans) {
            LatencyDistributionChartEntity entity = new LatencyDistributionChartEntity(this.designFileName, bean);
            boolean succes = this.insertSubReport(designBand, entity, 0, width, posY);
            if (!succes) break;
            posY = designBand.getHeight();
        }
    }

    private FlowInstanceManager getFlowInstanceManager() {
        return new FlowInstanceManager(this.getPersistenceController());
    }
}

