/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports.generator.chart;

import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.jasper.GenerateReport;
import com.excentis.products.byteblower.report.generator.jasper.datasource.ByteBlowerReportDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.CombinedDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.HttpThroughputRotChartDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.TcpReceiveWindowRotChartDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.TcpRetransmissionWindowRotChartDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.TcpThroughputRotChartDataSource;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.ResultsOverTimeChartBean;
import com.excentis.products.byteblower.report.generator.jasper.subreports.entities.MultiAxisResultsOverTimeChartEntity;
import com.excentis.products.byteblower.report.generator.jasper.subreports.entities.ResultsOverTimeChartEntity;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeCharts;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeSubReports;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpSessionReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.TcpSessionReader;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;

public class GenerateTcpThroughputResultsOverTimeCharts
extends GenerateResultsOverTimeCharts<HttpFlowInstance> {
    public GenerateTcpThroughputResultsOverTimeCharts(GenerateReport<GenerateReportListener> parentAction, ReportItemWidgetEntity widget, ReportGeneration reportGeneration, Class<HttpFlowInstance> flowType) {
        super(parentAction, widget, reportGeneration, flowType);
    }

    @Override
    protected ResultsOverTimeChartEntity createChartEntity(ResultsOverTimeChartBean<?> bean) {
        return new MultiAxisResultsOverTimeChartEntity(bean);
    }

    @Override
    protected boolean hasMultipleChartsPerFlow() {
        return true;
    }

    @Override
    protected void fillBeans() {
        Scenario scenario = this.getScenario();
        FlowInstanceManager manager = this.getFlowInstanceManager();
        List flowInstances = manager.getAllFlowsOfType(scenario, this.flowType);
        for (HttpFlowInstance flowInstance : flowInstances) {
            ArrayList<ByteBlowerReportDataSource> sources = this.createPagingQueries(flowInstance);
            TestDataReference testDataReference = this.getTestDataReference();
            CombinedDataSource data = new CombinedDataSource(sources);
            if (((ByteBlowerReportDataSource)data).isEmpty()) continue;
            this.beans.add(new ResultsOverTimeChartBean(testDataReference, (FlowInstance)flowInstance, (ByteBlowerReportDataSource)data));
        }
    }

    @Override
    protected ArrayList<ByteBlowerReportDataSource> createPagingQueries(HttpFlowInstance flowInstance) {
        ArrayList<ByteBlowerReportDataSource> result = new ArrayList<ByteBlowerReportDataSource>();
        if (flowInstance == null) {
            return result;
        }
        HttpFlowInstanceReader httpReader = EntityReaderFactory.create((HttpFlowInstance)flowInstance);
        if (httpReader == null || !httpReader.isValid(flowInstance)) {
            return result;
        }
        HttpSessionReader sourceSession = httpReader.getSourceHttpSessionReader();
        HttpSessionReader destinationSession = httpReader.getDestinationHttpSessionReader();
        if (sourceSession != null && destinationSession != null && destinationSession.getRxDurationNanoseconds() == null && sourceSession.getTxDurationNanoseconds() != null) {
            TcpSession tcpSessionSource = httpReader.getSourceHttpSession().getTcpSession();
            String flowName = httpReader.getName();
            EntityManager entityManager = this.getEntityManager();
            TcpSessionReader tcpSessionSourceReader = EntityReaderFactory.create((TcpSession)tcpSessionSource);
            TypedQuery httpQuery = sourceSession.getSnapshotsQuery(entityManager);
            TypedQuery tcpSourceQuery1 = tcpSessionSourceReader.getSnapshotsQuery(entityManager);
            TypedQuery tcpSourceQuery3 = tcpSessionSourceReader.getSnapshotsQuery(entityManager);
            result.add(HttpThroughputRotChartDataSource.txGoodput(entityManager, (GenerateResultsOverTimeSubReports<HttpFlowInstance>)this, flowName, "Goodput (Tx)", (TypedQuery<HttpSessionSnapshot>)httpQuery));
            result.add(TcpThroughputRotChartDataSource.txDataSource(entityManager, this, flowName, "Throughput (Tx)", (TypedQuery<TcpSessionSnapshot>)tcpSourceQuery1));
            result.add(new TcpReceiveWindowRotChartDataSource(entityManager, this, flowName, "Receive WIN DUMMY", (TypedQuery<TcpSessionSnapshot>)tcpSourceQuery3));
            result.add(new TcpRetransmissionWindowRotChartDataSource(entityManager, this, flowName, "Retransmissions", (TypedQuery<TcpSessionSnapshot>)tcpSourceQuery3));
            return result;
        }
        HttpSessionReader httpSessionReader = httpReader.getDestinationHttpSessionReader();
        TcpSession tcpSessionOnDestination = httpReader.getDestinationHttpSession().getTcpSession();
        TcpSession tcpSessionOnSource = httpReader.getSourceHttpSession().getTcpSession();
        String flowName = httpReader.getName();
        EntityManager entityManager = this.getEntityManager();
        TcpSessionReader tcpSessionDestinationReader = EntityReaderFactory.create((TcpSession)tcpSessionOnDestination);
        TcpSessionReader tcpSessionSourceReader = EntityReaderFactory.create((TcpSession)tcpSessionOnSource);
        TypedQuery httpQuery = httpSessionReader.getSnapshotsQuery(entityManager);
        TypedQuery tcpQuery = tcpSessionDestinationReader.getSnapshotsQuery(entityManager);
        result.add(HttpThroughputRotChartDataSource.rxGoodput(entityManager, (GenerateResultsOverTimeSubReports<HttpFlowInstance>)this, flowName, "Goodput", (TypedQuery<HttpSessionSnapshot>)httpQuery));
        result.add(TcpThroughputRotChartDataSource.rxDataSource(entityManager, (GenerateResultsOverTimeSubReports<HttpFlowInstance>)this, flowName, "Throughput", (TypedQuery<TcpSessionSnapshot>)tcpQuery));
        if (sourceSession.getTxDurationSeconds() != null) {
            TypedQuery tcpSourceQuery1 = tcpSessionSourceReader.getSnapshotsQuery(entityManager);
            TypedQuery tcpSourceQuery2 = tcpSessionSourceReader.getSnapshotsQuery(entityManager);
            result.add(new TcpReceiveWindowRotChartDataSource(entityManager, this, flowName, "Receive WIN DUMMY", (TypedQuery<TcpSessionSnapshot>)tcpSourceQuery1));
            result.add(new TcpRetransmissionWindowRotChartDataSource(entityManager, this, flowName, "Retransmissions", (TypedQuery<TcpSessionSnapshot>)tcpSourceQuery2));
        }
        return result;
    }

    @Override
    protected ByteBlowerReportDataSource createPagingQuery(HttpFlowInstance flowInstance) {
        ArrayList<ByteBlowerReportDataSource> queries = this.createPagingQueries(flowInstance);
        return (ByteBlowerReportDataSource)queries.get(0);
    }
}

